package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionHistory;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionHistoryMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionHistoryModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionHistoryService;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.Date;

/**
 * 检验检测历史数据表服务实现类
 *
 * @author system_generator
 * @date 2025-01-14
 */
@Service
public class JyjcInspectionHistoryServiceImpl extends BaseService<JyjcInspectionHistoryModel, JyjcInspectionHistory, JyjcInspectionHistoryMapper> implements IJyjcInspectionHistoryService {

    public JyjcInspectionHistory getBySSeq(Long sSeq) {
        return this.getOne(new LambdaQueryWrapper<JyjcInspectionHistory>().eq(JyjcInspectionHistory::getSSeq, sSeq));
    }

    public void saveBySeq(Long sSeq, JSONObject hisData, String sType) {
        JyjcInspectionHistory history = this.getBySSeq(sSeq);
        if (history != null) {
            history.setHistoryData(hisData);
            this.updateById(history);
        } else {
            history = new JyjcInspectionHistory();
            history.setHistoryData(hisData);
            history.setSSeq(sSeq);
            history.setRecDate(new Date());
            history.setSType(sType);
            super.saveOrUpdate(history);
        }
    }

}