package com.yeejoin.amos.boot.module.statistics.api.vo;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.annotation.write.style.ColumnWidth;
import com.alibaba.excel.annotation.write.style.ContentRowHeight;
import com.alibaba.excel.annotation.write.style.HeadRowHeight;
import com.yeejoin.amos.boot.module.common.api.converter.CommonCustomConverter;
import com.yeejoin.amos.boot.module.common.api.converter.EquipFieldCustomConverter;
import lombok.Data;

import java.util.Date;

/**
 * 设备
 */
@Data
@HeadRowHeight(35)// 标题行高度
@ContentRowHeight(15)// 内容行高度
@ColumnWidth(30)// 默认列宽
public class EquipInfoVo {

    // ----------------------------- 基本信息 ------------------------------------
    @ExcelProperty("管辖机构名称")
    private String ORG_BRANCH_NAME;

    @ExcelProperty("使用单位名称")
    private String USE_UNIT_NAME;

    @ExcelProperty("使用单位统一信用代码")
    private String USE_UNIT_CREDIT_CODE;

    @ExcelProperty("设备种类名称")
    private String EQU_LIST;

    @ExcelProperty("设备类别名称")
    private String EQU_CATEGORY;

    @ExcelProperty("设备品种名称")
    private String EQU_DEFINE;

    @ExcelProperty("使用登记证编号")
    private String USE_ORG_CODE;

    @ExcelProperty("注册代码")
    private String RECORD;

    @ExcelProperty("96333电梯码")
    private String CODE96333;

    @ExcelProperty("设备代码")
    private String EQU_CODE;

    @ExcelProperty("监管码")
    private String SUPERVISORY_CODE;

    @ExcelProperty("使用场所")
    private String USE_PLACE;

    @ExcelProperty("详细地址")
    private String ADDRESS;

    @ExcelProperty(value = "设备状态", converter = EquipFieldCustomConverter.EquStateConverter.class)
    private String EQU_STATE;

    @ExcelProperty("认领状态")
    private String STATUS;

    @ExcelProperty("安全管理员")
    private String SAFETY_MANAGER;

    @ExcelProperty("安全管理员电话")
    private String PHONE;

    @ExcelProperty("维保单位统一信用代码")
    private String MAINTAIN_UNIT;

    @ExcelProperty("维保单位名称")
    private String MAINTAIN_UNIT_NAME;

    @ExcelProperty("单位内部编号")
    private String USE_INNER_CODE;

    @ExcelProperty("出厂编号/产品编号")
    private String FACTORY_NUM;

    @ExcelProperty("制造单位名称")
    private String PRODUCE_UNIT_NAME;

    @ExcelProperty("安改维单位统一信用代码")
    private String USC_UNIT_CREDIT_CODE;

    @ExcelProperty("安改维单位统名称")
    private String USC_UNIT_NAME;

    @ExcelProperty(value = "投用日期", converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date USC_DATE;

    @ExcelProperty("产品名称")
    private String PRODUCT_NAME;

    @ExcelProperty("设备品牌")
    private String BRAND_NAME;

    @ExcelProperty("设备型号")
    private String EQU_TYPE;

    @ExcelProperty(value = "制造日期", converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date PRODUCE_DATE;

    @ExcelProperty("是否车用气瓶")
    private String WHETHER_VEHICLE_CYLINDER;

    @ExcelProperty("是否撬装式压力容器")
    private String WHETHER_SKID_MOUNTED_PRESSURE_VESSEL;

    @ExcelProperty("气瓶分类")
    private String CYLINDER_CATEGORY;

    @ExcelProperty("工程装置")
    private String PROJECT_CONTRAPTION;

    @ExcelProperty("信息化")
    private String INFORMATION_SITUATION;

    @ExcelProperty("工程装置id")
    private String projectContraptionId;

    @ExcelProperty("数据质量等级")
    private String dataQualityScore;

    @ExcelProperty("设计单位统一信用代码")
    private String designUnitCreditCode;

    @ExcelProperty("设计单位名称")
    private String designUnitName;

    @ExcelProperty("制造单位统一社会信用代码")
    private String produceUnitCreditCode;

    // ----------------------------- 最近一条检验信息------------------------------------
    @ExcelProperty(value = {"最近一条检验信息", "检验类型"}, converter = EquipFieldCustomConverter.InspectTypeConverter.class)
    private String inspectType;

    @ExcelProperty(value = {"最近一条检验信息", "检验机构名称"})
    private String inspectOrgName;

    @ExcelProperty(value = {"最近一条检验信息", "检验人员"})
    private String inspectStaff;

    @ExcelProperty(value = {"最近一条检验信息", "检验结论"}, converter = EquipFieldCustomConverter.InspectConclusionConverter.class)
    private String inspectConclusion;

    @ExcelProperty(value = {"最近一条检验信息", "检验日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date inspectDate;

    @ExcelProperty(value = {"最近一条检验信息", "下次检验日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date nextInspectDate;

    @ExcelProperty(value = {"最近一条检验信息", "检验机构编码"})
    private String inspectOrgCode;

    @ExcelProperty(value = {"最近一条检验信息", "报告编号"})
    private String inspectReportNo;

    // ----------------------------- 最近一条维保信息------------------------------------
    @ExcelProperty(value = {"最近一条维保信息", "维保单位统一社会信用代码"})
    private String meUnitCreditCode;

    @ExcelProperty(value = {"最近一条维保信息", "维保单位名称"})
    private String meUnitName;

    @ExcelProperty(value = {"最近一条维保信息", "维保备案合同"})
    private String repairInform;

    @ExcelProperty(value = {"最近一条维保信息", "维保合同开始日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date informStart;

    @ExcelProperty(value = {"最近一条维保信息", "维保合同结束日期"}, converter = CommonCustomConverter.Y_M_D_DateConverter.class)
    private Date informEnd;

    @ExcelProperty(value = {"最近一条维保信息", "维保负责人姓名"})
    private String meMaster;

    @ExcelProperty(value = {"最近一条维保信息", "维保负责人身份证"})
    private String meMasterId;

    @ExcelProperty(value = {"最近一条维保信息", "紧急救援电话"})
    private String emergencyCall;

    @ExcelProperty(value = {"最近一条维保信息", "维保周期"})
    private String meCycle;

    @ExcelProperty(value = {"最近一条维保信息", "大修周期"})
    private String overhaulCycle;

    @ExcelProperty(value = {"最近一条维保信息", "24小时维保电话"})
    private String me24Telephone;

    // ----------------------------- 所有设备类别技术参数 ------------------------------------
    @ExcelProperty(value = {"技术参数", "观光列车牵引车头座位数"})
    private String tractorSeatNumber;
    @ExcelProperty(value = {"技术参数", "小车运行速度"})
    private String smallcarrunSpeed;
    @ExcelProperty(value = {"技术参数", "给水温度"})
    private String feedwaterTemperature;
    @ExcelProperty(value = {"技术参数", "容器自重"})
    private String selfWeight;
    @ExcelProperty(value = {"技术参数", "材料（筒体）"})
    private String materialCylinder;
    @ExcelProperty(value = {"技术参数", "受压部件热处理温度"})
    private String heatTreatmentTemperatureOfPressureParts;
    @ExcelProperty(value = {"技术参数", "再热蒸汽流量"})
    private String reheatSteamFlow;
    @ExcelProperty(value = {"技术参数", "动力方式"})
    private String powerMode;
    @ExcelProperty(value = {"技术参数", "气体/粉尘组别（防爆）"})
    private String gasGroup;
    @ExcelProperty(value = {"技术参数", "单车最大进车时间"})
    private String bicycleMaxComeTime;
    @ExcelProperty(value = {"技术参数", "车辆VIN码"})
    private String vin;
    @ExcelProperty(value = {"技术参数", "再热器进（出）口温度"})
    private String inletOutletTemperatureOfReheater;
    @ExcelProperty(value = {"技术参数", "容器高(长)"})
    private String height;
    @ExcelProperty(value = {"技术参数", "适停车辆尺寸高"})
    private String parkingVehicleHeight;
    @ExcelProperty(value = {"技术参数", "额定载重量"})
    private String ratedLoadCapacity;
    @ExcelProperty(value = {"技术参数", "公称工作压力"})
    private String nominalWorkingPressure;
    @ExcelProperty(value = {"技术参数", "运行高度"})
    private String operatingHeight;
    @ExcelProperty(value = {"技术参数", "气体置换后压力"})
    private String displacementPressure;
    @ExcelProperty(value = {"技术参数", "运量"})
    private String freightVolume;
    @ExcelProperty(value = {"技术参数", "管道级别"}, converter = EquipFieldCustomConverter.DeviceLevelConverter.class)
    private String deviceLevel;
    @ExcelProperty(value = {"技术参数", "锅炉本体水（油）容积"})
    private String waterOilVolumeOfBoilerProper;
    @ExcelProperty(value = {"技术参数", "受压部件水（耐）压试验压力"})
    private String hydrostaticTestPressure;
    @ExcelProperty(value = {"技术参数", "起升速度"})
    private String liftingSpeed;
    @ExcelProperty(value = {"技术参数", "轴距"})
    private String wheelBase;
    @ExcelProperty(value = {"技术参数", "名义宽度"})
    private String nominalWidth;
    @ExcelProperty(value = {"技术参数", "设计温度"})
    private String temperature;
    @ExcelProperty(value = {"技术参数", "轮距（前）"})
    private String trackWidthFront;
    @ExcelProperty(value = {"技术参数", "无损检测比例（气瓶）"})
    private String qpRatio;
    @ExcelProperty(value = {"技术参数", "设备高度"})
    private String equipmentHeight;
    @ExcelProperty(value = {"技术参数", "热处理温度"})
    private String qpHeatTreatmentTemperature;
    @ExcelProperty(value = {"技术参数", "腐蚀裕量"})
    private String corrosionMargin;
    @ExcelProperty(value = {"技术参数", "单瓶容积"})
    private String singleBottleVolume;
    @ExcelProperty(value = {"技术参数", "耐压试验压力（管路）"})
    private String glPressure;
    @ExcelProperty(value = {"技术参数", "乘坐人数"})
    private String numberOfPassengers;
    @ExcelProperty(value = {"技术参数", "温度组别（防爆）"})
    private String temperatureGroup;
    @ExcelProperty(value = {"技术参数", "耐压试验种类"})
    private String withstandVoltage;
    @ExcelProperty(value = {"技术参数", "厚度（衬里）"})
    private String fixedLining;
    @ExcelProperty(value = {"技术参数", "厚度（筒体(球壳)）"})
    private String thickness;
    @ExcelProperty(value = {"技术参数", "跨度（工作幅度）"})
    private String spanWorkingRange;
    @ExcelProperty(value = {"技术参数", "设计温度（夹套）"})
    private String temperatureJacket;
    @ExcelProperty(value = {"技术参数", "最高允许工作压力（管程）"})
    private String maxPressurePipe;
    @ExcelProperty(value = {"技术参数", "设计温度（管程）"})
    private String temperaturePipe;
    @ExcelProperty(value = {"技术参数", "受压部件水（耐）压试验介质"})
    private String hydrostaticTestMedium;
    @ExcelProperty(value = {"技术参数", "层数/泊位数"})
    private String numberStorey;
    @ExcelProperty(value = {"技术参数", "倾角"})
    private String dip;
    @ExcelProperty(value = {"技术参数", "观光列车车厢数"})
    private String carsNumber;
    @ExcelProperty(value = {"技术参数", "额定起重量"})
    private String ratedLiftingCapacity;
    @ExcelProperty(value = {"技术参数", "额定蒸发量（热功率）"})
    private String ratedEvaporationCapacityThermalPower;
    @ExcelProperty(value = {"技术参数", "受压部件壁厚"})
    private String wallThicknessOfPressureParts;
    @ExcelProperty(value = {"技术参数", "工作介质"})
    private String workMedium;
    @ExcelProperty(value = {"技术参数", "材料（瓶体）"})
    private String bottleBody;
    @ExcelProperty(value = {"技术参数", "吊笼数量"})
    private String hangingCagesNumber;
    @ExcelProperty(value = {"技术参数", "额定速度(上行)"})
    private String ratedSpeedUp;
    @ExcelProperty(value = {"技术参数", "无损检测方法（管路）"}, converter = EquipFieldCustomConverter.GlLosslessConverter.class)
    private String glLossless;
    @ExcelProperty(value = {"技术参数", "管道名称（登记单元）"})
    private String pipeName;
    @ExcelProperty(value = {"技术参数", "气瓶安装位置"})
    private String installationPosition;
    @ExcelProperty(value = {"技术参数", "人均舱容"})
    private String perCapitaCabinCapacity;
    @ExcelProperty(value = {"技术参数", "运行速度"})
    private String runningSpeed;
    @ExcelProperty(value = {"技术参数", "高差"})
    private String altitudeDifference;
    @ExcelProperty(value = {"技术参数", "倾斜角"})
    private String angleRoll;
    @ExcelProperty(value = {"技术参数", "设计温度（壳程）"})
    private String temperatureShell;
    @ExcelProperty(value = {"技术参数", "自重"})
    private String weight;
    @ExcelProperty(value = {"技术参数", "存容量"})
    private String storageCapacity;
    @ExcelProperty(value = {"技术参数", "容积"})
    private String volume;
    @ExcelProperty(value = {"技术参数", "运载工具数量和类型"})
    private String numberAndTypeOfVehicles;
    @ExcelProperty(value = {"技术参数", "受压部件无损检测方法"})
    private String nonDestructiveTestingMethodsForPressureParts;
    @ExcelProperty(value = {"技术参数", "容器内径"})
    private String pressureVesselDiameter;
    @ExcelProperty(value = {"技术参数", "介质（管程）"})
    private String mediumPipe;
    @ExcelProperty(value = {"技术参数", "区域防爆等级"}, converter = EquipFieldCustomConverter.ExplosionProofGradeConverter.class)
    private String explosionProofGrade;
    @ExcelProperty(value = {"技术参数", "支座型式"})
    private String support;
    @ExcelProperty(value = {"技术参数", "变幅速度"})
    private String derrickingSpeed;
    @ExcelProperty(value = {"技术参数", "门数"})
    private String numberDoors;
    @ExcelProperty(value = {"技术参数", "大车运行速度"})
    private String bigcarRunSpeed;
    @ExcelProperty(value = {"技术参数", "设计温度"})
    private String designTemperature;
    @ExcelProperty(value = {"技术参数", "额定工作压力"})
    private String ratedWorkingPressure;
    @ExcelProperty(value = {"技术参数", "吊笼工作行程"})
    private String workStrokeCage;
    @ExcelProperty(value = {"技术参数", "管道长度"})
    private String pipeLength;
    @ExcelProperty(value = {"技术参数", "设计介质"})
    private String medium;
    @ExcelProperty(value = {"技术参数", "速度"})
    private String speed;
    @ExcelProperty(value = {"技术参数", "额定质量"})
    private String ratedQuality;
    @ExcelProperty(value = {"技术参数", "整车整备质量"})
    private String vehicleMass;
    @ExcelProperty(value = {"技术参数", "受压部件材料"})
    private String materialOfPressureParts;
    @ExcelProperty(value = {"技术参数", "公称壁厚"})
    private String wallThickness;
    @ExcelProperty(value = {"技术参数", "单车最大进(出)车时间"})
    private String bicycleMaxExitTime;
    @ExcelProperty(value = {"技术参数", "额定横移速度"})
    private String ratedTraverseSpeed;
    @ExcelProperty(value = {"技术参数", "受压部件无损检测比例"})
    private String proportionOfNdtForPressureParts;
    @ExcelProperty(value = {"技术参数", "单边摆角"})
    private String unilateralSwingAngle;
    @ExcelProperty(value = {"技术参数", "长度"})
    private String length;
    @ExcelProperty(value = {"技术参数", "规格"})
    private String specification;
    @ExcelProperty(value = {"技术参数", "材料（封头）"})
    private String pressureMaterialHead;
    @ExcelProperty(value = {"技术参数", "工作压力"})
    private String workingPressure;
    @ExcelProperty(value = {"技术参数", "罐车编号"})
    private String container;
    @ExcelProperty(value = {"技术参数", "材料（夹套）"})
    private String materialJacket;
    @ExcelProperty(value = {"技术参数", "压力"})
    private String chamberPressure;
    @ExcelProperty(value = {"技术参数", "蹦极绳长度"})
    private String slideHeight;
    @ExcelProperty(value = {"技术参数", "额定载客人数"})
    private String passengersNumber;
    @ExcelProperty(value = {"技术参数", "充装介质"}, converter = EquipFieldCustomConverter.ChargingMediumConverter.class)
    private String chargingMedium;
    @ExcelProperty(value = {"技术参数", "燃烧方式"})
    private String combustionMode;
    @ExcelProperty(value = {"技术参数", "设备保护等级（防爆）"}, converter = EquipFieldCustomConverter.ExplosionProofGradeConverter.class)
    private String protectGrade;
    @ExcelProperty(value = {"技术参数", "自由端高度"})
    private String heightFreeEnd;
    @ExcelProperty(value = {"技术参数", "轮距（后）"})
    private String trackWidthBehind;
    @ExcelProperty(value = {"技术参数", "空载最大运行速度"})
    private String carryingIdlerMaxRunningSpeed;
    @ExcelProperty(value = {"技术参数", "输送能力"})
    private String conveyingCapacity;
    @ExcelProperty(value = {"技术参数", "工作级别"}, converter = EquipFieldCustomConverter.WorkLevelConverter.class)
    private String workLevel;
    @ExcelProperty(value = {"技术参数", "发动机（行走电机）编号"})
    private String engineNo;
    @ExcelProperty(value = {"技术参数", "额定起重量"})
    private String liftingCapacity;
    @ExcelProperty(value = {"技术参数", "最高允许工作压力（壳程）"})
    private String maxPressureShell;
    @ExcelProperty(value = {"技术参数", "受压部件名称"}, converter = EquipFieldCustomConverter.NameOfPressurePartsConverter.class)
    private String nameOfPressureParts;
    @ExcelProperty(value = {"技术参数", "主体结构型式"}, converter = EquipFieldCustomConverter.MainStructureTypeConverter.class)
    private String mainStructureType;
    @ExcelProperty(value = {"技术参数", "额定升降速度"})
    private String ratedLiftSpeed;
    @ExcelProperty(value = {"技术参数", "设计压力（夹套）"})
    private String pressureJacket;
    @ExcelProperty(value = {"技术参数", "平距"})
    private String horizontalDistance;
    @ExcelProperty(value = {"技术参数", "名义速度"})
    private String nominalSpeed;
    @ExcelProperty(value = {"技术参数", "额定乘员数"})
    private String ratedMembers;
    @ExcelProperty(value = {"技术参数", "额定速度(下行)"})
    private String ratedSpeedDown;
    @ExcelProperty(value = {"技术参数", "材料（端塞）"})
    private String endPlug;
    @ExcelProperty(value = {"技术参数", "设计热效率"})
    private String designThermalEfficiency;
    @ExcelProperty(value = {"技术参数", "运载索"}, converter = EquipFieldCustomConverter.CarrierLineConverter.class)
    private String carrierLine;
    @ExcelProperty(value = {"技术参数", "区域防爆等级"}, converter = EquipFieldCustomConverter.ExplosionProofGradeConverter.class)
    private String explosionproofGrade;
    @ExcelProperty(value = {"技术参数", "支架数目"})
    private String supportsCount;
    @ExcelProperty(value = {"技术参数", "瓶体内含氧量"})
    private String heatTreatmentMethod;
    @ExcelProperty(value = {"技术参数", "最大充装量"})
    private String maxFill;
    @ExcelProperty(value = {"技术参数", "悬臂长度"})
    private String cantileverLength;
    @ExcelProperty(value = {"技术参数", "外径"})
    private String outsideDiameter;
    @ExcelProperty(value = {"技术参数", "气密性试验压力（管路）"})
    private String glAirTightness;
    @ExcelProperty(value = {"技术参数", "油缸数量"})
    private String numberCylinders;
    @ExcelProperty(value = {"技术参数", "安装型式"})
    private String installation;
    @ExcelProperty(value = {"技术参数", "最大运行速度"})
    private String maxRunningSpeed;
    @ExcelProperty(value = {"技术参数", "额定起重力矩"})
    private String ratedLiftingTorque;
    @ExcelProperty(value = {"技术参数", "站数"})
    private String stand;
    @ExcelProperty(value = {"技术参数", "承载索"})
    private String bearingCable;
    @ExcelProperty(value = {"技术参数", "气密性试验压力（气瓶）"})
    private String qpAirTightness;
    @ExcelProperty(value = {"技术参数", "氧舱品种"})
    private String oxygenChamber;
    @ExcelProperty(value = {"技术参数", "控制方式"}, converter = EquipFieldCustomConverter.ControlModeConverter.class)
    private String controlMode;
    @ExcelProperty(value = {"技术参数", "提升高度"})
    private String liftingHeight;
    @ExcelProperty(value = {"技术参数", "轨道高度"})
    private String trackHeight;
    @ExcelProperty(value = {"技术参数", "回转直径"})
    private String rotaryDiameter;
    @ExcelProperty(value = {"技术参数", "罐车编号"})
    private String carNum;
    @ExcelProperty(value = {"技术参数", "有机热载体锅炉气密试验介质/压力"})
    private String glAirtightTest;
    @ExcelProperty(value = {"技术参数", "受压部件热处理时间"})
    private String heatTreatmentTimeOfPressureParts;
    @ExcelProperty(value = {"技术参数", "顶升方式"}, converter = EquipFieldCustomConverter.JackingTypeConverter.class)
    private String jackingType;
    @ExcelProperty(value = {"技术参数", "燃料（热源）种类"}, converter = EquipFieldCustomConverter.FuelTypeConverter.class)
    private String fuelType;
    @ExcelProperty(value = {"技术参数", "设计压力（管程）"})
    private String pressurePipe;
    @ExcelProperty(value = {"技术参数", "型号"})
    private String modelNumber;
    @ExcelProperty(value = {"技术参数", "厚度（筒体）"})
    private String thicknessCylinder;
    @ExcelProperty(value = {"技术参数", "总容积"})
    private String totalVolume;
    @ExcelProperty(value = {"技术参数", "主电机型式"})
    private String mainMotorModel;
    @ExcelProperty(value = {"技术参数", "厚度（夹套）"})
    private String fixedJacket;
    @ExcelProperty(value = {"技术参数", "数量"})
    private String num;
    @ExcelProperty(value = {"技术参数", "设计压力"})
    private String designPressure;
    @ExcelProperty(value = {"技术参数", "工作装置空载最大起升高度"})
    private String maxLiftingHeight;
    @ExcelProperty(value = {"技术参数", "盛装介质重量"})
    private String mediumWeight;
    @ExcelProperty(value = {"技术参数", "主体结构"})
    private String chamberMain;
    @ExcelProperty(value = {"技术参数", "公称直径"})
    private String nominalDiameter;
    @ExcelProperty(value = {"技术参数", "最大起重量"})
    private String maxLiftingCapacity;
    @ExcelProperty(value = {"技术参数", "容器容积"})
    private String containerVolume;
    @ExcelProperty(value = {"技术参数", "管道编号"})
    private String pipelineNumber;
    @ExcelProperty(value = {"技术参数", "额定提升速度"})
    private String ratedLiftingSpeed;
    @ExcelProperty(value = {"技术参数", "空载最大起升速度"})
    private String maxLiftingSpeed;
    @ExcelProperty(value = {"技术参数", "额定出/回水(油)温度"})
    private String ratedOutletReturnWaterOilTemperature;
    @ExcelProperty(value = {"技术参数", "索距"})
    private String cablePitch;
    @ExcelProperty(value = {"技术参数", "瓶体内含氧量"})
    private String oxygen;
    @ExcelProperty(value = {"技术参数", "适停车辆尺寸宽"})
    private String parkingVehicleWeight;
    @ExcelProperty(value = {"技术参数", "工作压力"})
    private String workPressure;
    @ExcelProperty(value = {"技术参数", "斜长"})
    private String obliqueLength;
    @ExcelProperty(value = {"技术参数", "最大起重力矩"})
    private String maxLiftingTorque;
    @ExcelProperty(value = {"技术参数", "耐压试验压力（气瓶）"})
    private String qpPressure;
    @ExcelProperty(value = {"技术参数", "泄漏试验压力"})
    private String leakPressure;
    @ExcelProperty(value = {"技术参数", "设计压力"})
    private String pressure;
    @ExcelProperty(value = {"技术参数", "压力介质"})
    private String pressureMedium;
    @ExcelProperty(value = {"技术参数", "材料（筒体(球壳)）"})
    private String materialCylinderShell;
    @ExcelProperty(value = {"技术参数", "保温绝热方式"})
    private String insulation;
    @ExcelProperty(value = {"技术参数", "无损检测方法（气瓶）"}, converter = EquipFieldCustomConverter.GlLosslessConverter.class)
    private String qpLossless;
    @ExcelProperty(value = {"技术参数", "车辆数"})
    private String numberOfVehicles;
    @ExcelProperty(value = {"技术参数", "无损检测比例（管路）"})
    private String glRatio;
    @ExcelProperty(value = {"技术参数", "轿门位置"})
    private String doorPosition;
    @ExcelProperty(value = {"技术参数", "泄漏试验种类"})
    private String leakage;
    @ExcelProperty(value = {"技术参数", "车架编号"})
    private String frameNo;
    @ExcelProperty(value = {"技术参数", "传动方式"})
    private String transmissionMode;
    @ExcelProperty(value = {"技术参数", "额定速度"})
    private String ratedSpeed;
    @ExcelProperty(value = {"技术参数", "最大行驶坡度"})
    private String maxDrivingSlope;
    @ExcelProperty(value = {"技术参数", "泄漏试验压力"})
    private String withstandPressureTest;
    @ExcelProperty(value = {"技术参数", "观光列车每节车厢座位数"})
    private String seatNumber;
    @ExcelProperty(value = {"技术参数", "主电机功率"})
    private String mainMotorPower;
    @ExcelProperty(value = {"技术参数", "适停车辆尺寸长"})
    private String parkingVehicleLength;
    @ExcelProperty(value = {"技术参数", "整装锅炉本体液压试验介质/压力"})
    private String hydraulicTestMediumPressureOfPackagedBoilerBody;
    @ExcelProperty(value = {"技术参数", "驾驶方式"})
    private String drivingMode;
    @ExcelProperty(value = {"技术参数", "介质（壳程）"})
    private String mediumShell;
    @ExcelProperty(value = {"技术参数", "额定工作温度"})
    private String ratedOperatingTemperature;
    @ExcelProperty(value = {"技术参数", "再热器进（出）口压力"})
    private String reheaterInletOutletPressure;
    @ExcelProperty(value = {"技术参数", "整机防爆标志"})
    private String explosionproofSignComplete;
    @ExcelProperty(value = {"技术参数", "无损检测方法"}, converter = EquipFieldCustomConverter.GlLosslessConverter.class)
    private String checkLossless;
    @ExcelProperty(value = {"技术参数", "车架结构"})
    private String frameStructure;
    @ExcelProperty(value = {"技术参数", "燃爆物质"})
    private String explosiveSubstance;
    @ExcelProperty(value = {"技术参数", "设计压力（壳程）"})
    private String pressureHousingPath;
    @ExcelProperty(value = {"技术参数", "额定进舱人数"})
    private String ratedEntryCapacity;
    @ExcelProperty(value = {"技术参数", "张紧油压（重锤重量）"})
    private String oilPressureHeavyHammer;
    @ExcelProperty(value = {"技术参数", "使用环境温度"})
    private String ambientTemperature;
    @ExcelProperty(value = {"技术参数", "最高允许工作压力（夹套）"})
    private String maxPressureJacket;
    @ExcelProperty(value = {"技术参数", "滑道长度"})
    private String slideLength;
    @ExcelProperty(value = {"技术参数", "材料（管路）"})
    private String piping;
    @ExcelProperty(value = {"技术参数", "材料（衬里）"})
    private String pressureMaterialLining;
    @ExcelProperty(value = {"技术参数", "工作温度"})
    private String workTemperature;
    @ExcelProperty(value = {"技术参数", "厚度（封头）"})
    private String fixedHead;
    @ExcelProperty(value = {"技术参数", "使用区段长度"})
    private String useSectionLength;
    @ExcelProperty(value = {"技术参数", "备注"})
    private String remarks;
    @ExcelProperty(value = {"技术参数", "介质（夹套）"})
    private String mediumJacket;

}
