package com.yeejoin.amos.boot.module.tcm.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.HashMap;
import java.util.Map;

public class QualificationLevelConverter implements Converter<String> {

    private static final Map<String,String> CODE_MAP = new HashMap<>();

    static {
        CODE_MAP.put("检验员","JYY");
        CODE_MAP.put("检验师","JYS");
        CODE_MAP.put("高级检验师","GJJYS");
    }

    @Override
    public Class supportJavaTypeKey() {
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        String cellDataStr = cellData.getStringValue();
        return CODE_MAP.get(cellDataStr);
    }

    @Override
    public CellData convertToExcelData(String value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return null;
    }
}
