package com.yeejoin.amos.boot.module.tcm.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.*;

import java.util.Date;

/**
 * 风险报送 处置过程表
 *
 * @author system_generator
 * @date 2025-08-08
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName("tzs_risk_processes")
public class RiskProcesses extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 风险报送主表seq，关联关系
     */
	@TableField("risk_report_seq")
    private String riskReportSeq;

    /**
     * 业务单位类型（处置单位/整改单位）
     */
	@TableField("unit_type")
    private String unitType;

    /**
     * 业务处置方式code（确认已处置/无需处置/下发整改/整改上报）
     */
	@TableField("disposal_way_code")
    private String disposalWayCode;

    /**
     * 业务处置方式name（确认已处置/无需处置/下发整改/整改上报）
     */
	@TableField("disposal_way_name")
    private String disposalWayName;

    /**
     * 整改内容,监管下发的整改意见/企业上报的整改情况说明
     */
	@TableField("disposal_content")
    private String disposalContent;

    /**
     * 附件
     */
	@TableField("disposal_file")
    private String disposalFile;

    /**
     * 操作单位seq
     */
	@TableField("operation_company_seq")
    private String operationCompanySeq;

    /**
     * 操作单位name
     */
	@TableField("operation_company_name")
    private String operationCompanyName;

    /**
     * 操作人userId
     */
	@TableField("operation_user_id")
    private String operationUserId;

    /**
     * 操作人userName
     */
	@TableField("operation_user_name")
    private String operationUserName;

    /**
     * 创建时间（根据此时间排序可获取一条风险的完整处置流程）
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 创建人id 
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建人
     */
	@TableField("create_user_name")
    private String createUserName;

    /**
     * 备注
     */
    @TableField("remark")
    private String remark;

}
