package com.yeejoin.amos.boot.module.tcm.api.enums;

/**
 * 
 * <pre>
 * 电梯轿厢是否在门区
 * </pre>
 *
 * @author gwb
 * @version $Id: LiftIszoneEnum.java, v 0.1 2021年9月29日 上午9:35:27 gwb Exp $
 */
public enum LiftIszoneEnum{

	NON_DOOR_AREA(0,"轿厢在非门区"),
	DOOR_AREA (1,"轿厢在门区");

	/**
	 * 编码
	 */
	private Integer code;

	/**
	 * 名称
	 */
	private String name;


	// 构造方法
	private LiftIszoneEnum(Integer code, String name) {
		this.code = code;
		this.name = name;
	}


	public Integer getCode() {
		return code;
	}
	
	public String getName()
	{
		return name;
	}
	
	public static LiftIszoneEnum getEnum(Integer code)
	{
		for (LiftIszoneEnum liftIszoneEnum : LiftIszoneEnum.values())
		{
			if (liftIszoneEnum.getCode().equals(code))
			{
				return liftIszoneEnum;
			}
		}
		return null;
	}
}
