//package com.yeejoin.amos.patrol.config;
//
//
//import lombok.Getter;
//import lombok.Setter;
//import lombok.extern.slf4j.Slf4j;
//import org.apache.commons.lang3.StringUtils;
//import org.apache.shardingsphere.driver.jdbc.core.datasource.ShardingSphereDataSource;
//
//import org.springframework.beans.factory.annotation.Value;
//import org.springframework.stereotype.Component;
//import org.springframework.util.Assert;
//
//import javax.annotation.PostConstruct;
//import javax.annotation.Resource;
//import javax.sql.DataSource;
//import java.sql.Connection;
//import java.sql.ResultSet;
//import java.sql.SQLException;
//import java.sql.Statement;
//import java.util.HashMap;
//import java.util.Map;
//
///**
// * @author liran
// */
//@Slf4j
//@Setter
//@Getter
//@Component
//public class TableCreate {
//
//    @Resource
//    private ShardingSphereDataSource dataSource;
//
//    Map<String, Object> createdTables = new HashMap<>();
//    @Value("${shardingsphere.create.tables.num:10}")
//    private String num;
//
//    private String PLAN_TASK = "p_plan_task";
//    private String PLAN_TASK_HISTORY = "p_plan_task_history_";
//
//    private String PLAN_TASK_DETAIL = "p_plan_task_detail";
//    private String PLAN_TASK_DETAIL_HISTORY = "p_plan_task_detail_history_";
//
//    private String P_CHECK = "p_check";
//    private String P_CHECK_HISTORY = "p_check_history_";
//
//    private String P_CHECK_INPUT = "p_check_input";
//    private String P_CHECK_INPUT_HISTORY = "p_check_input_history_";
//
//    private String P_CHECK_SHOT = "p_check_shot";
//    private String P_CHECK_SHOT_HISTORY = "p_check_shot_history_";
//
//    private String DB = "amos_tzs_biz.";
//
//
//    @PostConstruct
//    public void init() {
//        for(int i = 1; i<=Integer.parseInt(num); i++) {
//            createNeedTime(PLAN_TASK,DB,PLAN_TASK_HISTORY+i);
//        }
//        for(int i = 1; i<=Integer.parseInt(num); i++) {
//            createNeedTime(PLAN_TASK_DETAIL,DB,PLAN_TASK_DETAIL_HISTORY+i);
//        }
//        for(int i = 1; i<=Integer.parseInt(num); i++) {
//            createNeedTime(P_CHECK,DB,P_CHECK_HISTORY+i);
//        }
//        for(int i = 1; i<=Integer.parseInt(num); i++) {
//            createNeedTime(P_CHECK_INPUT,DB,P_CHECK_INPUT_HISTORY+i);
//        }
//        for(int i = 1; i<=Integer.parseInt(num); i++) {
//            createNeedTime(P_CHECK_SHOT,DB,P_CHECK_SHOT_HISTORY+i);
//        }
//    }
//
//
//    private void createNeedTime(String table, String db, String create) {
//        DataSource dataSource = this.dataSource;
//        String sql = "SHOW CREATE TABLE " + table;
//        String existSql = "select * from information_schema.tables where table_name ='" + table + "'; ";
//        doCreate(dataSource, sql, existSql, create, db, table);
//    }
//
//    private void doCreate(DataSource dataSource, String sql, String existSql, String create, String db, String table) {
//        String msg = " create table: " + create + "  origin table: " + table + "  db: " + db;
//        Connection conn = null;
//        Statement stmt = null;
//        try {
//            conn = dataSource.getConnection().getMetaData().getConnection();
//            stmt = conn.createStatement();
//            ResultSet resultSet = stmt.executeQuery(existSql);
//            Assert.isTrue(resultSet.next(), msg + "初始化表不存在");
//
//            ResultSet resTable = stmt.executeQuery(sql);
//            Assert.isTrue(resTable.next(), msg + "初始化表不存在");
//            String existTableName = resTable.getString(1);
//            String createSqlOrigin = resTable.getString(2);
//            // log.info(existTableName, createSqlOrigin);
//
//            String existSqlNew = StringUtils.replaceOnce(existSql, existTableName, create);
//            ResultSet executeQuery = stmt.executeQuery(existSqlNew);
//            if (executeQuery.next()) {
//                log.info("table exist :" + msg);
//            } else {
//                createSqlOrigin = createSqlOrigin.substring(0,createSqlOrigin.indexOf(";"));
//                String creatsql = StringUtils.replace(createSqlOrigin, existTableName, create).replaceFirst(create, DB+create).replace("bigint(64)", "int8").replace("smallint(16)","int2");
//                if (0 == stmt.executeUpdate(creatsql)) {
//                    log.info(msg + "success ！");
//
//                } else {
//                    log.error(msg + "fail ！");
//                }
//            }
//        } catch (Exception e) {
//            log.error("create  table fail  error : {} ", e.getMessage());
//        } finally {
//            if (stmt != null) {
//                try {
//                    stmt.close();
//                } catch (SQLException e) {
//                    log.error("SQLException", e);
//                }
//            }
//            if (conn != null) {
//                try {
//                    conn.close();
//                } catch (SQLException e) {
//                    log.error("SQLException", e);
//                }
//            }
//        }
//    }
//
//}
