package com.yeejoin.amos.boot.module.ymt.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;

/**
 * 气瓶基本信息
 *
 * @author duanwei
 * @date 2022-08-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_info")
@ApiModel(value="TzCylinderInfo对象", description="气瓶基本信息")
public class CylinderInfo extends BaseEntity {

    private static final long serialVersionUID = 1L;




    @ApiModelProperty(value = "产权单位名称")
    private String unitName;

    @ApiModelProperty(value = "出厂编号")
    private String factoryNum;

    @ApiModelProperty(value = "气瓶状态")
    private Integer cylinderStatus;

    @ApiModelProperty(value = "气瓶品种")
    private Integer cylinderVariety;

    @ApiModelProperty(value = "容积（L）")
    private Double volume;

    @ApiModelProperty(value = "制造日期")
    private String manufacturingDate;

    @ApiModelProperty(value = "制造单位")
    private String manufacturingUnit;

    @ApiModelProperty(value = "单位内部编号")
    private String unitInnerCode;

    @ApiModelProperty(value = "气瓶唯一标识码")
    private String sequenceCode;

    @ApiModelProperty(value = "Ԥ???ȼ?")
    private String earlyWarningLevel;

    @ApiModelProperty(value = "????Ԥ??ʱ?")
    private Date earlyWarningLevelCalDate;

    @ApiModelProperty(value = "????վ??ʹ???û????")
    private String endCustomCode;



    @ApiModelProperty(value = "同步时间  yyyy-MM-dd HH24:mi:ss")
    private Date syncDate;

    @ApiModelProperty(value = "0-新增   1-更新  2-删除")
    private Integer syncState;

    @ApiModelProperty(value = "对接公司编码")
    private String appId;

    @ApiModelProperty(value = "数据完整度")
    private Double integrity;

    @ApiModelProperty(value = "???")
    private String longitude;

    @ApiModelProperty(value = "γ?")
    private String latitude;

    @ApiModelProperty(value = "统一社会信用代码")
    private String creditCode;

    @ApiModelProperty(value = "充装介质")
    private String fillingMedia;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品合格证")
    private String productQualified;

    @ApiModelProperty(value = "质量证明书")
    private String proofQuality;

    @ApiModelProperty(value = "监督检验证书")
    private String supervisionInspec;

    @ApiModelProperty(value = "型式实验证书")
    private String typeExperiments;

    @ApiModelProperty(value = "阀门制造单位")
    private String valveManufacturUnit;

    @ApiModelProperty(value = "公称工作压力(MPa）")
    private Double nominalWorkPressure;

    @ApiModelProperty(value = "设备品种名称")
    private String cylinderVarietyName;

    @ApiModelProperty(value = "充装介质名称")
    private String fillingMediaName;

    @ApiModelProperty(value = "监管码")
    private String SupervisionCode;

    @ApiModelProperty(value = "是否保存到es（1标识已经保存过）")
    private String isNotEs;

}
