package com.yeejoin.amos.boot.module.ymt.flc.api.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.module.ymt.flc.api.dto.EquipmentInformDto;
import org.typroject.tyboot.core.foundation.exception.BaseException;

import java.util.List;

/**
 * 设备告知单接口类
 *
 * @author system_generator
 * @date 2021-12-10
 */
public interface IEquipmentInformService {

    EquipmentInformDto createEquipmentInform(EquipmentInformDto model, ReginParams userInfo);

    /**
     * 获取本单位提交的告知书列表
     * @param page
     * @param equipmentInformDto
     * @param sortParam
     * @param sortRule
     * @return
     */
    Page<EquipmentInformDto> queryDtoList(Page<EquipmentInformDto> page, EquipmentInformDto equipmentInformDto, String sortParam, String sortRule);

    /**
     * 获取监管端查看的告知书列表
     * @param page
     * @param equipmentInformDto
     * @param sortParam
     * @param sortRule
     * @return
     */
    Page<EquipmentInformDto> queryDtoListSub(Page<EquipmentInformDto> page, EquipmentInformDto equipmentInformDto, String sortParam, String sortRule);

    Boolean batchDelete(List<Long> sequenceNbrList);

    Boolean acceptInform(Long sequenceNbr);

    EquipmentInformDto updateEquipmentInform(EquipmentInformDto model, ReginParams userInfo) throws BaseException;

    EquipmentInformDto queryDtoBySeq(Long sequenceNbr);

    /**
     * 启动 告知书流程
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean startWorkflow(Long sequenceNbr, ReginParams userInfo) throws Exception;

    /**
     * 接收方接收告知书
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean acceptInform(Long sequenceNbr, ReginParams userInfo) throws Exception;
    /**
     * 企业移交告知书
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean transferInform(Long sequenceNbr, ReginParams userInfo, Long transferUnitId) throws Exception;

    /**
     * 企业撤回告知书
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean withdrawInform(Long sequenceNbr, ReginParams userInfo) throws Exception;
    /**
     * 接收方驳回告知书
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean dismissInform(Long sequenceNbr, ReginParams userInfo) throws Exception;
    /**
     * 企业撤销告知书
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean cancelInform(Long sequenceNbr, ReginParams userInfo) throws Exception;

    /**
     * 企业再次提交
     * @param sequenceNbr
     * @param userInfo
     * @return
     * @throws Exception
     */
    Boolean reSubmit(Long sequenceNbr, ReginParams userInfo) throws Exception;

    /**
     * 监管端撤回已经通过的告知书
     * @param sequenceNbr
     * @return
     */
    Boolean callbackInform(Long sequenceNbr);

}
