package com.yeejoin.amos.boot.module.ymt.biz.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import com.yeejoin.amos.boot.module.ymt.api.dto.AlertFormValueDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.AlertForm;
import com.yeejoin.amos.boot.module.ymt.api.entity.AlertFormValue;
import com.yeejoin.amos.boot.module.ymt.api.mapper.AlertFormValueMapper;
import com.yeejoin.amos.boot.module.ymt.api.service.IAlertFormValueService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;
import java.util.Map;


/**
*  服务实现类
*
* @author tb
* @date 2021-06-17
*/
@Service
public class AlertFormValueServiceImpl extends  BaseService<AlertFormValueDto, AlertFormValue, AlertFormValueMapper>  implements IAlertFormValueService {

	@Autowired
	private AlertFormValueMapper alertFormValueMapper;

	@Autowired
	private AlertFormServiceImpl alertFormService;
	
	public List<AlertFormValueDto> queryByCalledId(Long alertCalledId) {
		return this.queryForList(null, false, alertCalledId);
	}

	public List<AlertFormValueDto> listByCalledId(Long id) {
		return alertFormValueMapper.selectListByCalledId(id);
	}

	/**
	 * 根据动态表单分组类型查询改分组下所有数据实例
	 *
	 * @param groupCode
	 * @return List<Map <String, Object>>
	 */
	public List<Map<String, Object>> listAll(String groupCode, Map<String, String> queryParams) {
		List<AlertForm> columns =
				alertFormService.list(new LambdaQueryWrapper<AlertForm>().eq(AlertForm::getAlertTypeCode, groupCode));
		List<String> fieldCodes = Lists.transform(columns, AlertForm::getFieldCode);
		return this.baseMapper.listAll(fieldCodes, groupCode, queryParams);
	}


}
