package com.yeejoin.amos.boot.module.jyjc.api.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.typroject.tyboot.core.rdbms.model.BaseModel;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 业务开通申请表
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JyjcInspectionResultModel", description = "业务开通申请表")
public class JyjcInspectionResultModel extends BaseModel {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "检验检测单位编码")
    private String inspectionUnitCode;

    @ApiModelProperty(value = "报检单号")
    private String applicationNo;

    @ApiModelProperty(value = "报检单位编号")
    private String applicationUnitCode;

    //监管码
    @ApiModelProperty(value = "设备唯一标识")
    private String equipUnicode;

    @ApiModelProperty(value = "检验结果状态（已出2、未出1）")
    private String resultStatus;

    @ApiModelProperty(value = "检验结果状态名称（已出2、未出1）（冗余）")
    private String resultStatusName;

    @ApiModelProperty(value = "核准证号/许可证号")
    private String licenseNumber;

    @ApiModelProperty(value = "检验报告编号")
    private String resultNo;

    @ApiModelProperty(value = "检验人员（多个逗号分割）")
    private String inspector;

    @ApiModelProperty(value = "内部人员代码")
    private String innerPersonCode;

    @ApiModelProperty(value = "检验结论")
    private String inspectionConclusion;

    @ApiModelProperty(value = "检验日期")
    private Date inspectionDate;

    @ApiModelProperty(value = "下次检验日期")
    private Date nextInspectionDate;

    @ApiModelProperty(value = "检验开始日期")
    private Date inspectionStartDate;

    @ApiModelProperty(value = "检验结束日期")
    private Date inspectionEndDate;

    @ApiModelProperty(value = "检验结果汇总")
    private String inspectionResultSummary;

    @ApiModelProperty(value = "不符合项")
    private String nonConformance;

    @ApiModelProperty(value = "整改情况")
    private String rectification;

    @ApiModelProperty(value = "备注(无用预留)")
    private String remark;

    @ApiModelProperty(value = "业务类型（与菜单对应拆表使用）")
    private String bizType;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "检验检测类型编码")
    private String inspectionType;

    @ApiModelProperty(value = "检验检测类型名称（冗余）")
    private String inspectionTypeName;

    @ApiModelProperty(value = "报检日期")
    private Date applicationDate;

    @ApiModelProperty("检验结果方式")
    private String resultType;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "使用登记证编号")
    private String useOrgCode;

    @ApiModelProperty(value = "单位内部编号")
    private String useInnerCode;

    @ApiModelProperty(value = "注册代码")
    private String equCode;

    /**
     *  设备使用地点 = 设备使用地点省（province_name）+设备使用地点市（city_name）+
     *  设备使用地点区（county_name）+设备使用地点街道（street_name）+设备使用地点详细（address）
     */
    @ApiModelProperty(value = "设备使用地点")
    private String equAddress;

    @ApiModelProperty(value = "使用单位")
    private String useUnitName;

    @ApiModelProperty(value = "使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "检验结果技术参数")
    private Map<String,Object> resultParamModelMap;

    @ApiModelProperty(value = "附件类型(特种设备检验报告:1,监检证书:2)")
    private String attachmentType;


    @ApiModelProperty(value = "设备品种")
    private String equDefine;
}
