package com.yeejoin.amos.boot.module.jyjc.biz.controller;

import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jyjc.biz.service.impl.CommonserviceImpl;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzBaseEnterpriseInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.TzsUserInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import java.util.List;

/**
 * @author system_generator
 * @date 2023-12-13
 */
@RestController
@Api(tags = "公共接口controller")
@RequestMapping(value = "/common")
public class CommonController extends BaseController {

    @Autowired
    CommonserviceImpl commonserviceImpl;

    /**
     * 新增
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @PostMapping(value = "/getJyjcPersonByUnitCode")
    @ApiOperation(httpMethod = "GET", value = "根据公司的unitCode获取检测检验人员列表", notes = "根据公司的unitCode获取检测检验人员列表")
    public ResponseModel<List<TzsUserInfo>> getUserInfosByUnitCode(@RequestParam String unitCode) {
        return ResponseHelper.buildResponse(commonserviceImpl.getUserInfosByUnitCode(unitCode));
    }

    /**
     * 查询检验检测机构列表（基本信息及联系人）
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getInspectionUnitList")
    @ApiOperation(httpMethod = "GET", value = "查询检验检测机构列表（基本信息及联系人）", notes = "查询检验检测机构列表（基本信息及联系人）")
    public ResponseModel<List<TzBaseEnterpriseInfo>> getInspectionUnitList() {
        return ResponseHelper.buildResponse(commonserviceImpl.getInspectionUnitList());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/getInspectionUnit/{sequenceNbr}")
    @ApiOperation(httpMethod = "GET", value = "查询检验检测机构基本信息", notes = "查询检验检测机构基本信息")
    public ResponseModel<TzBaseEnterpriseInfo> getInspectionUnitBySequenceNbr(@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
        return ResponseHelper.buildResponse(commonserviceImpl.getInspectionUnitBySequenceNbr(sequenceNbr));
    }

}
