package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Sequence;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.utils.RedisKey;
import com.yeejoin.amos.boot.biz.common.utils.RedisUtils;
import com.yeejoin.amos.boot.module.jyjc.api.common.StringUtil;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResult;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultAttachment;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionResultParam;
import com.yeejoin.amos.boot.module.jyjc.api.enums.ResultStatusEnum;
import com.yeejoin.amos.boot.module.jyjc.api.mapper.JyjcInspectionResultMapper;
import com.yeejoin.amos.boot.module.jyjc.api.model.JyjcInspectionResultModel;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultAttachmentService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultParamService;
import com.yeejoin.amos.boot.module.jyjc.api.service.IJyjcInspectionResultService;
import com.yeejoin.amos.boot.module.jyjc.biz.utils.JsonUtils;
import com.yeejoin.amos.boot.module.ymt.api.entity.CategoryOtherInfo;
import com.yeejoin.amos.boot.module.ymt.api.entity.InspectionDetectionInfo;
import com.yeejoin.amos.boot.module.ymt.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.ymt.api.mapper.CategoryOtherInfoMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.EquipmentCategoryMapper;
import com.yeejoin.amos.boot.module.ymt.api.mapper.InspectionDetectionInfoMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.typroject.tyboot.core.foundation.context.RequestContext;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 业务开通申请表服务实现类
 *
 * @author system_generator
 * @date 2023-12-14
 */
@Service
public class JyjcInspectionResultServiceImpl extends BaseService<JyjcInspectionResultModel, JyjcInspectionResult, JyjcInspectionResultMapper> implements IJyjcInspectionResultService {

    private static final String JYJC_SUBMIT_FILE_PREFIX = "JYJC_";
    private static final String JYJC_SUBMIT_KEY = "inspectResult";

    @Autowired
    private IJyjcInspectionResultAttachmentService iJyjcInspectionResultAttachmentService;

    @Autowired
    private IJyjcInspectionResultParamService iJyjcInspectionResultParamService;

    @Autowired
    EquipmentCategoryMapper equipmentCategoryMapper;

    @Value("classpath:/json/equipCategory.json")
    private Resource equipCategory;

    @Autowired
    JyjcInspectionResultMapper resultMapper;

    @Autowired
    JyjcInspectionResultParamServiceImpl resultParamService;
    @Autowired
    JyjcInspectionResultAttachmentServiceImpl attachmentService;
    @Autowired
    private RedisUtils redisUtils;

    @Autowired
    CategoryOtherInfoMapper categoryOtherInfoMapper;

    @Autowired
    InspectionDetectionInfoMapper inspectionDetectionInfoMapper;

    @Autowired
    private Sequence sequence;

    /**
     * 检验检测单位分页查询
     */
    public Page<JyjcInspectionResultModel> queryForJyjcInspectionResultPage(Page<JyjcInspectionResultModel> page, JyjcInspectionResultModel model, boolean type) {
        ReginParams reginParams = JSON.parseObject(redisUtils.get(RedisKey.buildReginKey(RequestContext.getExeUserId(),
                RequestContext.getToken())).toString(), ReginParams.class);
        if (ObjectUtils.isEmpty(model)) {
            model = new JyjcInspectionResultModel();
        }
        if (type) {
            //检验检测单位分页查询
            model.setInspectionUnitCode(reginParams.getCompany().getCompanyCode());
        } else {
            //报检单位分页查询
            model.setApplicationUnitCode(reginParams.getCompany().getCompanyCode());
        }
        Page<JyjcInspectionResultModel> resultPage = resultMapper.selectJyjcInspectionResultpPage(page, model);
        resultPage.getRecords().stream().forEach(v -> {
            if (ResultStatusEnum.NO_RESULT.getCode().equals(v.getResultStatus()))
                v.setResultStatusName(ResultStatusEnum.NO_RESULT.getName());
            if (ResultStatusEnum.YES_RESULT.getCode().equals(v.getResultStatus()))
                v.setResultStatusName(ResultStatusEnum.YES_RESULT.getName());
        });
        return resultPage;
    }


    @Transactional(rollbackFor = Exception.class)
    public JyjcInspectionResultModel updateJyjcInspectionResult(Map<String, Map<String, Object>> tableModel) {

        Map<String, Object> map = tableModel.get(JYJC_SUBMIT_KEY);
        JyjcInspectionResultModel model = BeanUtil.mapToBean(map, JyjcInspectionResultModel.class, true);

        // 更新结果主表
        updateWithModel(model);

        // 更新附件表
        List<JyjcInspectionResultAttachment> attachmentList = new ArrayList<>();
        LambdaQueryWrapper<JyjcInspectionResultAttachment> fileWrapper = new LambdaQueryWrapper<>();
        Map<String, Object> fileMap = new HashMap<>();
        map.forEach((k, v) -> {
            if (k.contains(JYJC_SUBMIT_FILE_PREFIX) && !ObjectUtils.isEmpty(map.get(k))) {
                fileWrapper.or(wrapper ->wrapper.eq(JyjcInspectionResultAttachment::getAttachmentType, k).eq(JyjcInspectionResultAttachment::getResultSeq, model.getSequenceNbr()));
                fileMap.put(k, map.get(k));
            }
        });
        List<JyjcInspectionResultAttachment> fileList = attachmentService.list(fileWrapper);
        fileMap.forEach((k, v) -> {
            JyjcInspectionResultAttachment attachment = new JyjcInspectionResultAttachment();
            attachment.setResultSeq(model.getSequenceNbr());
            attachment.setAttachmentUrl(JSON.toJSONString(map.get(k)));
            attachment.setAttachmentType(k);
            // 新增时需要判断之前有就更新
            if (!CollectionUtils.isEmpty(fileList)) {
                List<JyjcInspectionResultAttachment> collect = fileList.stream().filter(obj -> k.equals(obj.getAttachmentType())).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(collect)) {
                    JyjcInspectionResultAttachment jyjcInspectionResultAttachment = collect.get(0);
                    attachment.setSequenceNbr(jyjcInspectionResultAttachment.getSequenceNbr());
                }
            }
            attachmentList.add(attachment);
        });
        if (!CollectionUtils.isEmpty(attachmentList)) {
            attachmentService.saveOrUpdateBatch(attachmentList);
        }

        // 更新参数表
        if (!CollectionUtils.isEmpty(model.getResultParamModelMap())){
            LambdaQueryWrapper<JyjcInspectionResultParam> paramWrapper = new LambdaQueryWrapper<>();
            paramWrapper.eq(JyjcInspectionResultParam::getResultSeq, model.getSequenceNbr());
            List<JyjcInspectionResultParam> params = resultParamService.list(paramWrapper);
            JyjcInspectionResultParam resultParam = new JyjcInspectionResultParam();
            resultParam.setResultSeq(model.getSequenceNbr());
            resultParam.setParamJson(JSON.toJSONString(model.getResultParamModelMap()));
            if (!CollectionUtils.isEmpty(params)) {
                JyjcInspectionResultParam jyjcInspectionResultParam = params.get(0);
                resultParam.setSequenceNbr(jyjcInspectionResultParam.getSequenceNbr());
            }
            resultParamService.saveOrUpdate(resultParam);
        }

        //插入操作历史记录
        InspectionDetectionInfo info = new InspectionDetectionInfo();
        QueryWrapper<InspectionDetectionInfo> wrapper = new QueryWrapper<>();
        wrapper.lambda().eq(InspectionDetectionInfo::getInspectReportNo, model.getResultNo());
        List<InspectionDetectionInfo> list = inspectionDetectionInfoMapper.selectList(wrapper);
        if (CollectionUtils.isEmpty(list)) {
            QueryWrapper<CategoryOtherInfo> queryWrapper = new QueryWrapper<>();
            queryWrapper.lambda().eq(CategoryOtherInfo::getSupervisoryCode, model.getEquipUnicode());
            List<CategoryOtherInfo> otherInfos = categoryOtherInfoMapper.selectList(queryWrapper);
            if (!CollectionUtils.isEmpty(otherInfos)) {
                info.setRecord(otherInfos.get(0).getRecord());
            }
            extracted(model, info);
            info.setSequenceNbr(sequence.nextId() + "");
            inspectionDetectionInfoMapper.insert(info);
        } else {
            info = list.get(0);
            extracted(model, info);
            inspectionDetectionInfoMapper.updateById(info);
        }
        return model;
    }

    private void extracted(JyjcInspectionResultModel model, InspectionDetectionInfo info) {
        info.setInspectType(model.getInspectionType());
        info.setInspectOrgName(model.getInspectionUnitCode());
//        info.setInspectReport(JSON.toJSONString(model.getResultAttachmentModelList()));
        info.setInspectDate(model.getInspectionDate());
        info.setInspectConclusion(model.getInspectionConclusion());
        info.setProblemRemark(model.getNonConformance());
        info.setNextInspectDate(model.getNextInspectionDate());
        info.setSequenceCode(model.getEquipUnicode());
        info.setInspectOrgCode(model.getUseUnitCreditCode());
        info.setInspectReportNo(model.getResultNo());
    }

    /**
     * 列表查询 示例
     */
    public List<JyjcInspectionResultModel> queryForJyjcInspectionResultList() {
        return this.queryForList("", false);
    }

    @Override
    public Map<String, Object> queryDetailBySeq(Long sequenceNbr) {
        Map<String, Object> map = new HashMap<>();

        JyjcInspectionResultModel jyjcInspectionResultModel = this.queryBySeq(sequenceNbr);
        if (!ObjectUtils.isEmpty(jyjcInspectionResultModel)) {
            // 对象转map
            map = BeanUtil.beanToMap(jyjcInspectionResultModel);

            // 获取附件
            List<JyjcInspectionResultAttachment> attachmentList = iJyjcInspectionResultAttachmentService.getObjByResultSeq(sequenceNbr);
            if (!CollectionUtils.isEmpty(attachmentList)) {
                Map<String, Object> attachmentMap = attachmentList.stream().map(obj -> {
                    if (StringUtil.isNotEmpty(obj.getAttachmentUrl())) {
                        obj.setAttachmentUrlList(JSONArray.parseArray(obj.getAttachmentUrl()));
                    }
                    return obj;
                }).collect(Collectors.toMap(JyjcInspectionResultAttachment::getAttachmentType, JyjcInspectionResultAttachment::getAttachmentUrlList));
                map.putAll(attachmentMap);
            }

            // 获取技术参数
            List<JyjcInspectionResultParam> paramList = iJyjcInspectionResultParamService.getParamByResultSeq(sequenceNbr);
            Map<String, Object> mapParam = new HashMap<>();
            if (!CollectionUtils.isEmpty(paramList)) {
                paramList.forEach(param -> {
                    if (!ObjectUtils.isEmpty(param.getParamJson())) {
                        mapParam.putAll(JSON.parseObject(param.getParamJson()));
                    }
                });
                map.put("paramJson", mapParam);
            }
        }
        Map<String, Object> resultMap = new HashMap<>();
        resultMap.put(JYJC_SUBMIT_KEY, map);
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> equipList(String type, String notNode) {
        List<Map<String, Object>> menus = new ArrayList<>();
        Map<String, List<Map<String, Object>>> resourceJson = JsonUtils.getResourceJson(equipCategory);
        List<Map<String, Object>> mapList;
        if (ValidationUtil.isEmpty(type)) {
            mapList = resourceJson.get(EquipmentClassifityEnum.BDLS.getCode());
        } else {
            mapList = resourceJson.get(type);
        }

        mapList.stream().filter(map -> {
            if (!ObjectUtils.isEmpty(notNode)) {
                String[] code = notNode.split(",");
                List<String> codeList = Arrays.asList(code);
                return !codeList.contains(map.get("code"));
            }
            return true;
        }).forEach(obj -> {
            Map<String, Object> resultMap = new HashMap<>(2);
            resultMap.put("instanceName", obj.get("name"));
            resultMap.put("instanceId", obj.get("code"));
            menus.add(resultMap);
        });

        return menus;
    }
}