package com.yeejoin.amos.boot.module.jg.api.mapper;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.mapper.CustomBaseMapper;
import com.yeejoin.amos.boot.module.jg.api.dto.CompanyEquipCountDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgChangeRegistrationUnitDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgChangeRegistrationUnit;
import com.yeejoin.amos.boot.module.jg.api.vo.SortVo;
import com.yeejoin.amos.boot.module.jg.api.vo.tableDataExportVo.ChangeRegistrationUnitVo;
import org.apache.ibatis.annotations.MapKey;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 单位变更登记 Mapper 接口
 *
 * @author system_generator
 * @date 2023-12-22
 */
public interface JgChangeRegistrationUnitMapper extends CustomBaseMapper<JgChangeRegistrationUnit> {

    /**
     * 分页查询
     *
     * @param page  分页对象
     * @param model 查询参数
     * @param type  类型：enterprise-企业端、supervision-监管端
     * @return 安装告知列表
     */
    Page<JgChangeRegistrationUnit> queryForPage(Page<JgChangeRegistrationUnit> page,
                                                @Param("sort") SortVo sortMap,
                                                @Param("param") JgChangeRegistrationUnitDto model,
                                                @Param("type") String type,
                                                @Param("companyCode") String companyCode,
                                                @Param("roleIds") List<String> roleIds,
                                                @Param("currentUserId") String currentUserId,
                                                @Param("orgCode") String orgCode);

    List<ChangeRegistrationUnitVo> queryChangeRegistrationUnitInIds(@Param("ids") List<String> ids);

    /**
     * 根据安装告知编号查询设备、设计、制造等信息
     *
     * @param sequenceNbr 安装告知编号
     */
    @MapKey("sequenceNbr")
    List<Map<String, Object>> queryEquipInformation(@Param("sequenceNbr") long sequenceNbr);

    String queryEquipIdBySeq(@Param("sequenceNbr") long sequenceNbr);

    List<CompanyEquipCountDto> queryForFlowingEquipList();

    List<Map<String, Object>> getEstateUnitInfo(List<String> records);
}
