package com.yeejoin.amos.boot.module.jcs.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;
/**
* 警情接警记录
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("jc_alert_called")
@ApiModel(value="AlertCalled对象", description="警情接警记录")
public class AlertCalled extends BaseEntity {
    /**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(value = "警情状态")
    private Boolean alertStatus;

    @ApiModelProperty(value = "系统/人工")
    private String type;

    @ApiModelProperty(value = "警情阶段")
    private String alertStage;

    @ApiModelProperty(value = "报警类型")
    private String alarmType;
    @ApiModelProperty(value = "响应级别字典code 为了过滤用（只有航空器故障有）")
    private String responseLevelCode;

    @ApiModelProperty(value = "响应级别")
    private String responseLevel;
    
    @ApiModelProperty(value = "报警类型code")
    private String alarmTypeCode;

    @ApiModelProperty(value = "通话记录信息id")
    private Integer callRecordId;

    @ApiModelProperty(value = "父警情id")
    private Long fatherAlert;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "接警时间")
    private Date callTime;

    @ApiModelProperty(value = "接警时长")
    private Double callTimeNum;

    @ApiModelProperty(value = "警情来源")
    private String alertSource;

    @ApiModelProperty(value = "警情来源code")
    private String alertSourceCode;

    @ApiModelProperty(value = "警情类型")
    private String alertType;

    @ApiModelProperty(value = "警情类型code")
    private String alertTypeCode;

    @ApiModelProperty(value = "事发单位")
    private String unitInvolved;

    @ApiModelProperty(value = "被困人数")
    private Integer trappedNum;

    @ApiModelProperty(value = "伤亡人数")
    private Integer casualtiesNum;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "救援方格")
    private String rescueGrid;

    @ApiModelProperty(value = "经度")
    private Double coordinateX;

    @ApiModelProperty(value = "纬度")
    private Double coordinateY;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "接警时间开始---用于列表过滤")
    @TableField(exist=false)
    private Date callTimeStart ;

    @ApiModelProperty(value = "接警时间结束---用于列表过滤")
    @TableField(exist=false)
    private Date callTimeEnd ;
  
    @TableField(exist=false)
    @ApiModelProperty(value = "是否处警")
    private Boolean isFatherAlert = false;

    @TableField(exist=false)
    @ApiModelProperty(value = "当前登录人公司名称")
    private String companyName;
    
    @TableField(exist=false)
    @ApiModelProperty(value = "警情来源多选 [逗号分隔]")
    private String alertSourceCodeStr;
}
