package com.yeejoin.amos.boot.module.common.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.common.biz.service.impl.WaterResourceIndexServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceIndexDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 消防水源物联参数
 *
 * @author litw
 * @date 2021-11-02
 */
@RestController
@Api(tags = "消防水源物联参数Api")
@RequestMapping(value = "/water-resource-index")
public class WaterResourceIndexController extends BaseController {

    @Autowired
    WaterResourceIndexServiceImpl waterResourceIndexServiceImpl;

    /**
     * 新增消防水源物联参数
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增消防水源物联参数", notes = "新增消防水源物联参数")
	public ResponseModel<WaterResourceIndexDto> save(@RequestBody WaterResourceIndexDto model) {
	    model = waterResourceIndexServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新消防水源物联参数", notes = "根据sequenceNbr更新消防水源物联参数")
	public ResponseModel<WaterResourceIndexDto> updateBySequenceNbrWaterResourceIndex(@RequestBody WaterResourceIndexDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(waterResourceIndexServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除消防水源物联参数", notes = "根据sequenceNbr删除消防水源物联参数")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(waterResourceIndexServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个消防水源物联参数",  notes = "根据sequenceNbr查询单个消防水源物联参数")
	public ResponseModel<WaterResourceIndexDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(waterResourceIndexServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "消防水源物联参数分页查询",  notes = "消防水源物联参数分页查询")
	public ResponseModel<Page<WaterResourceIndexDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<WaterResourceIndexDto> page = new Page<WaterResourceIndexDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(waterResourceIndexServiceImpl.queryForWaterResourceIndexPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "消防水源物联参数列表全部数据查询",   notes = "消防水源物联参数列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<WaterResourceIndexDto>> selectForList() {
	    return ResponseHelper.buildResponse(waterResourceIndexServiceImpl.queryForWaterResourceIndexList());
	}
}
