package com.yeejoin.amos.boot.module.jg.api.enums;

import lombok.Getter;
import org.apache.commons.compress.utils.Lists;
import org.typroject.tyboot.core.foundation.utils.ValidationUtil;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * 业务类型枚举
 *
 * @author Administrator
 */
@Getter
public enum CompanyTypeEnum {

    /**
     * 单位类型枚举
     */
    SUPERVISION("supervision","supervision", "监管机构"),

    USE("company","use", "使用单位"),

    DESIGN("company","design", "设计单位"),

    MANUFACTURE("company","manufacture", "制造单位"),

    FILLING("company","filling", "充装单位"),

    INDIVIDUAL("company","individual", "个人主体"),

    CONSTRUCTION("company","construction", "安装改造维修单位"),

    INSPECTION("company","inspection", "检验机构"),

    INSPECTION_CE("company","inspection", "检测机构");

    private final String level;
    private final String code;
    private final String name;

    CompanyTypeEnum(String level, String code, String name) {
        this.level = level;
        this.code = code;
        this.name = name;
    }

    public static String getNameByType(String code) {
        String name = null;
        for (CompanyTypeEnum enumOne : CompanyTypeEnum.values()) {
            if (enumOne.getCode().equals(code)) {
                name = enumOne.getName();
                break;
            }
        }
        return name;
    }

    public static String decideCompanyLevel(String str) {
        List<CompanyTypeEnum> typeList = getCompanyTypeEnums(str);
        if (typeList == null) return null;
        String result;
        Set<String> set = new HashSet<>();
        for (CompanyTypeEnum one : typeList) {
            set.add(one.getLevel());
        }
        result = String.join(",", set);
        return result;
    }

    private static List<CompanyTypeEnum> getCompanyTypeEnums(String str) {
        if (ValidationUtil.isEmpty(str)) {
            return null;
        }
        List<CompanyTypeEnum> typeList = Lists.newArrayList();
        for (CompanyTypeEnum enumOne : CompanyTypeEnum.values()) {
            if (str.contains(enumOne.getName())) {
                typeList.add(enumOne);
            }
        }
        if (ValidationUtil.isEmpty(typeList)) {
            return null;
        }
        return typeList;
    }

    public static String decideCompanyCode(String str) {
        List<CompanyTypeEnum> typeList = getCompanyTypeEnums(str);
        if (typeList == null) return null;
        String result;
        Set<String> set = new HashSet<>();
        for (CompanyTypeEnum one : typeList) {
            set.add(one.getCode());
        }
        result = String.join(",", set);
        return result;
    }

    public static String decideCompanyType(String str) {
        List<CompanyTypeEnum> typeList = getCompanyTypeEnums(str);
        if (typeList == null) return null;
        String result;
        Set<String> set = new HashSet<>();
        for (CompanyTypeEnum one : typeList) {
            set.add(one.getName());
        }
        result = String.join(",", set);
        return result;
    }
}
