package com.yeejoin.equip.entity;

import io.github.classgraph.json.Id;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldType;
import java.util.Date;
/**
 * @description:
 * @author: LiuLin
 * @createDate: 2023/09/18
 */

@Data
@AllArgsConstructor
@NoArgsConstructor
@Document(indexName = "jxiop_equipments")
public class ESEquipments {
    @Id
    private String  id;
    @Field(type = FieldType.Text, index = false)
    private String  address;
    @Field(type = FieldType.Text)
    private String  dataType;
    @Field(type = FieldType.Text)
    private String  equipmentSpecificName;
    @Field(type = FieldType.Keyword)
    private String  gatewayId;
    @Field(type = FieldType.Text)
    private String  isAlarm;
    @Field(type = FieldType.Date, format = DateFormat.basic_date_time, index = false)
    private Date createdTime;
    @Field(type = FieldType.Text , index = false)
    private String  unit;
    @Field(type = FieldType.Text)
    private String  value;
    @Field(type = FieldType.Float, index = false)
    private Float  valueF;
    @Field(type = FieldType.Text)
    private String  valueLabel;
    @Field(type = FieldType.Text , index = false)
    private String  traceId;
    @Field(type = FieldType.Keyword )
    private String  equipmentIndexName;
    @Field(type = FieldType.Keyword )
    private String  equipmentNumber;
    @Field(type = FieldType.Text)
    private String  frontModule;
    @Field(type = FieldType.Text)
    private String  systemType;
    @Field(type = FieldType.Text , index = false)
    private String  pictureName;
    @Field(type = FieldType.Text)
    private String  displayName;
}
