package com.yeejoin.equip.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import java.io.Serializable;
import java.util.Date;

@Data
@ToString
@AllArgsConstructor
@NoArgsConstructor
@ApiModel(value = "性能指标详情返回vo实体", description = "性能指标详情返回vo实体")
public class EquipmentIndexVO implements Serializable {
    @ApiModelProperty(value = "id")
    private Long id;

    @ApiModelProperty(value = "值")
    private String value;

    @ApiModelProperty(value = "equipment_id")
    private String equipmentId;

    @ApiModelProperty(value = "性能指标名称")
    private String perfQuotaName;

    @ApiModelProperty(value = "性能指标id")
    private String perfQuotaDefinitionId;

    @ApiModelProperty(value = "数量单位名称")
    private String unitName;

    @ApiModelProperty(value = "否物联指标")
    private Integer isIot;

    @ApiModelProperty(value = "物联指标")
    private String typeName;

    @ApiModelProperty(value = "物联指标ID")
    private String typeCode;

    @ApiModelProperty(value = "分类名称")
    private String groupName;

    @ApiModelProperty(value = "指标原始id，从iot平台接口获取")
    private String indexId;

    @ApiModelProperty(value = "性能指标")
    private String perfQuotaStr;

    @ApiModelProperty(value = "是否是核心参数")
    private Boolean isImportentParameter;

    @ApiModelProperty(value = "排序")
    private Integer sortNum;

    @ApiModelProperty(value = "類型")
    private Integer type;

    @ApiModelProperty(value = "物联nameKey")
    private String nameKey;

    @ApiModelProperty(value = "创建日期")
    private Date createDate;

    @ApiModelProperty(value = "更新日期")
    private Date updateDate;

    @ApiModelProperty(value = "是否支持趋势查看")
    private Integer isTrend;

    @ApiModelProperty(value = "是否告警")
    private Integer isAlarm;

    @ApiModelProperty(value = "指标枚举")
    private String valueEnum;

    @ApiModelProperty(value = "信号的索引键key，用于唯一索引信号")
    private String indexAddress;

    @ApiModelProperty(value = "测点类型，analog/state")
    private String dataType;

    @ApiModelProperty(value = "网关标识")
    private String gatewayId;

    @ApiModelProperty(value = "装备名称")
    private String equipmentSpecificName;

    @ApiModelProperty(value = "装备指标名称")
    private String equipmentIndexName;

}
