package com.yeejoin.equip.service;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.yeejoin.equip.entity.ESEquipments;
import com.yeejoin.equip.mapper.tdengine.ESEquipmentsMapper;
import com.yeejoin.equip.utils.ElasticSearchUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import java.util.List;

/**
 * @author LiuLin
 * @date 2023/6/25
 * @apiNote ES数据十分钟存入TDEngine
 */
@Slf4j
@Component
public class HandleESMessage2TDService {
    public static final String ES_INDEX = "jxiop_equipments";
    public static final int SIZE = 1000;
    @Autowired
    private ESEquipmentsMapper esEquipmentsMapper;
    @Autowired
    private ElasticSearchUtil elasticSearchUtil;

    /**
     * 十分钟拉取ES数据存入TdEngine
     */
    @Scheduled(cron = "0 */10 * * * ?")
    @Transactional(rollbackFor = Exception.class)
    public void syncEsData2TDEngine() throws Exception {
        List<ESEquipments> result = elasticSearchUtil.searchResponse(ES_INDEX, null, hit -> JSON.parseObject(hit.getSourceAsString(), ESEquipments.class));
        List<List<ESEquipments>> allDataList = Lists.partition(result, SIZE);
        for (List<ESEquipments> tempDataList : allDataList) {
            if (CollectionUtils.isNotEmpty(tempDataList)) {
                esEquipmentsMapper.batchInsert(tempDataList);
            }
        }
    }
}
