package com.yeejoin.equip.service;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.component.influxdb.InfluxDbConnection;
import com.yeejoin.equip.entity.IndicatorData;
import com.yeejoin.equip.kafka.KafkaProducerService;
import com.yeejoin.equip.mapper.tdengine.IndicatorDataMapper;
import com.yeejoin.equip.utils.ElasticSearchUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
/**
 * @author LiuLin
 * @date 2023/6/25
 * @apiNote Emq消息转发Kafka
 */
@Slf4j
@Component("handleMessageService")
public class HandleMessageService {
    private static final String MEASUREMENT = "iot_data_";
    private static final String ES_INDEX_NAME_JX = "jxiop_equipments";
    @Autowired
    protected KafkaProducerService kafkaProducerService;
    @Autowired
    private InfluxDbConnection influxDbConnection;
    @Autowired
    private IndicatorDataMapper indicatorDataMapper;
    @Value("${kafka.alarm.topic}")
    private String alarmTopic;
    @Autowired
    private ElasticSearchUtil elasticSearchUtil;

    public void processMessage(IndicatorData indicatorData) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Map<String, String> tagsMap = new HashMap<>();
            Map<String, Object> fieldsMap = new HashMap<>();
            tagsMap.put("equipmentsIdx", indicatorData.getEquipmentsIdx());

            fieldsMap.put("address", indicatorData.getAddress());
            fieldsMap.put("gatewayId", indicatorData.getGatewayId());
            fieldsMap.put("dataType", indicatorData.getDataType());
            fieldsMap.put("isAlarm", indicatorData.getIsAlarm());
            fieldsMap.put("equipmentSpecificName", indicatorData.getEquipmentSpecificName());
            fieldsMap.put("value", indicatorData.getValue());
            fieldsMap.put("valueLabel", indicatorData.getValueLabel().isEmpty() ? indicatorData.getValue() : indicatorData.getValueLabel());
            fieldsMap.put("equipmentIndexName", indicatorData.getEquipmentIndexName());
            fieldsMap.put("unit", indicatorData.getUnit());
            fieldsMap.put("createdTime", simpleDateFormat.format(new Date()));

            if ("transformation".equals(indicatorData.getSignalType())) {
                influxDbConnection.insert(MEASUREMENT + indicatorData.getGatewayId(), tagsMap, fieldsMap);
                indicatorDataMapper.insert(indicatorData);
            }

            //更新数据入ES库
            Map<String, Object> paramJson = new HashMap<>();
            paramJson.put("valueF", indicatorData.getValueF());
            paramJson.put("value", indicatorData.getValue());
            paramJson.put("valueLabel", indicatorData.getValueLabel().isEmpty() ? indicatorData.getValue() : indicatorData.getValueLabel());
            paramJson.put("createdTime", new Date());
            paramJson.put("unit", indicatorData.getUnit());
            elasticSearchUtil.updateData(ES_INDEX_NAME_JX, indicatorData.getEquipmentsIdx(), JSON.toJSONString(paramJson));

            if (indicatorData.getIsAlarm() != null && "1".equals(indicatorData.getIsAlarm())) {
                fieldsMap.putAll(tagsMap);
                kafkaProducerService.sendMessageAsync(alarmTopic, JSON.toJSONString(fieldsMap));
            }
        } catch (Exception e) {
            log.error("Iot透传消息解析入库失败" + e.getMessage(), e);
        }
    }
}
