package com.yeejoin.amos.boot.module.common.api.dto;

import java.io.Serializable;
import java.util.List;

import com.alibaba.excel.annotation.ExcelIgnore;
import com.alibaba.excel.annotation.ExcelProperty;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
@Data
@ApiModel(value = "DutyFireFightingExcleDto", description = "微型消防站值班")
public class DutyFireFightingExcleDto implements Serializable{

	@ExcelIgnore
	private static final long serialVersionUID = 1L;
	
	@ExcelProperty(value = "序号", index = 0)
	@ApiModelProperty(value = "序号")
	private Integer number;
	
	@ExcelIgnore
	@ApiModelProperty(value = "单位ID")
	private String teamId;

	@ExcelProperty(value = "单位名称", index = 1)
	@ApiModelProperty(value = "单位名称")
	private String teamName;
	
	
	@ExcelIgnore
	@ApiModelProperty(value = "用户id")
	private String userId;
	@ExcelProperty(value = "用户名称", index = 2)
	@ApiModelProperty(value = "用户名称")
	private String userName;


//	@ExcelIgnore
//	@ApiModelProperty(value = "部门id")
//	private String deptId;
//	@ExcelIgnore
//	@ApiModelProperty(value = "部门名称")
//	private String deptName;

	@ExcelIgnore
	@ApiModelProperty(value = "岗位id")
	private String postType;

	@ExcelProperty(value = "岗位", index = 3)
	@ApiModelProperty(value = "岗位名称")
	private String postTypeName;
	
	@ExcelProperty(value = "微型消防站", index = 4)
	@ApiModelProperty(value = "微型消防站")
	private String fireFighting;

	@ExcelIgnore
	@ApiModelProperty(value = "微型消防站Id")
	private String fireFightingId;
	@ExcelIgnore
	@ApiModelProperty(value = "值班信息")
	private List<DutyPersonShiftDto> dutyShift;

	@ExcelIgnore
	@ApiModelProperty(value = "值班开始时间")
	private String startTime;

	@ExcelIgnore
	@ApiModelProperty(value = "值班结束时间")
	private String endTime;


}
