package com.yeejoin.amos.boot.module.jg.biz.edit.factory;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import com.yeejoin.amos.boot.module.jg.api.dto.FieldChangeMeta;
import com.yeejoin.amos.boot.module.jg.biz.edit.typeHandler.FormatService;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Objects;

@Component
@RequiredArgsConstructor
public class StringColumnDiffHandler implements ColumnDiff {

    private final FormatService formatService;

    @Override
    public boolean supports(Class<?> type) {
        return type == String.class;
    }

    @Override
    public <T> FieldChangeMeta handleWithWrapper(FieldDisplayDefine displayDefine, Object oldVal, Object newVal, Field field, Group group, String changeId, TableField tableField, UpdateWrapper<T> wrapper) {
        if (!Objects.equals(oldVal, newVal)) {
            String columnName = tableField.value();
            wrapper.set(columnName, newVal);
            String fieldName = displayDefine.value();
            FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
            fieldChangeMeta.setColumnKey(field.getName());
            fieldChangeMeta.setColumnFamily(group.value());
            fieldChangeMeta.setColumnLabel(fieldName);
            fieldChangeMeta.setChangeId(changeId);
            fieldChangeMeta.setIsRepeatColumn(displayDefine.isRepeatColumn());
            // 字段类型前端渲染时使用
            fieldChangeMeta.setColumnType(displayDefine.type().getSimpleName());
            if (newVal instanceof String) {
                fieldChangeMeta.setColumnOldValue((String) oldVal);
                fieldChangeMeta.setColumnNewValue((String) newVal);
            } else if (newVal instanceof Number) {
                fieldChangeMeta.setColumnOldValue(String.valueOf(oldVal));
                fieldChangeMeta.setColumnNewValue(String.valueOf(newVal));
            } else if (newVal instanceof Date) {
                fieldChangeMeta.setColumnOldValue(DateUtil.formatDate((Date) oldVal));
                fieldChangeMeta.setColumnNewValue(DateUtil.formatDate((Date) newVal));
            } else if (newVal instanceof Boolean) {
                fieldChangeMeta.setColumnOldValue(Boolean.toString((Boolean) oldVal));
                fieldChangeMeta.setColumnNewValue(Boolean.toString((Boolean) newVal));
            } else {
                fieldChangeMeta.setColumnOldValue(Objects.toString(oldVal, null));
                fieldChangeMeta.setColumnNewValue(Objects.toString(newVal, null));
            }
            fieldChangeMeta.setDisplayOldValue(formatService.format(displayDefine, fieldChangeMeta.getColumnOldValue()));
            fieldChangeMeta.setDisplayNewValue(formatService.format(displayDefine, fieldChangeMeta.getColumnNewValue()));
            return fieldChangeMeta;
        }
        return null;
    }

    @Override
    public FieldChangeMeta handleNoWrapper(FieldDisplayDefine displayDefine, Object oldVal, Object newVal, Field field, Group group, String changeId) {
        if (!Objects.equals(oldVal, newVal)) {
            String fieldName = displayDefine.value();
            FieldChangeMeta fieldChangeMeta = new FieldChangeMeta();
            fieldChangeMeta.setColumnKey(field.getName());
            fieldChangeMeta.setColumnFamily(group.value());
            fieldChangeMeta.setColumnLabel(fieldName);
            fieldChangeMeta.setChangeId(changeId);
            fieldChangeMeta.setIsRepeatColumn(displayDefine.isRepeatColumn());
            // 字段类型前端渲染时使用
            fieldChangeMeta.setColumnType(displayDefine.type().getSimpleName());
            if (newVal instanceof String) {
                fieldChangeMeta.setColumnOldValue((String) oldVal);
                fieldChangeMeta.setColumnNewValue((String) newVal);
            } else if (newVal instanceof Number) {
                fieldChangeMeta.setColumnOldValue(String.valueOf(oldVal));
                fieldChangeMeta.setColumnNewValue(String.valueOf(newVal));
            } else if (newVal instanceof Date) {
                fieldChangeMeta.setColumnOldValue(DateUtil.formatDate((Date) oldVal));
                fieldChangeMeta.setColumnNewValue(DateUtil.formatDate((Date) newVal));
            } else if (newVal instanceof Boolean) {
                fieldChangeMeta.setColumnOldValue(Boolean.toString((Boolean) oldVal));
                fieldChangeMeta.setColumnNewValue(Boolean.toString((Boolean) newVal));
            } else {
                fieldChangeMeta.setColumnOldValue(Objects.toString(oldVal, null));
                fieldChangeMeta.setColumnNewValue(Objects.toString(newVal, null));
            }
            fieldChangeMeta.setDisplayOldValue(formatService.format(displayDefine, fieldChangeMeta.getColumnOldValue()));
            fieldChangeMeta.setDisplayNewValue(formatService.format(displayDefine, fieldChangeMeta.getColumnNewValue()));
            return fieldChangeMeta;
        }
        return null;
    }
}