package com.yeejoin.amos.boot.module.ymt.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorDto;
import com.yeejoin.amos.boot.module.ymt.api.dto.ElevatorWlInfoDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.Elevator;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
*  Mapper 接口
*
* @author tb
* @date 2021-06-01
*/
public interface ElevatorMapper extends BaseMapper<Elevator> {

    List<ElevatorWlInfoDto>  queryElevatorList(String address,
                                               String registerCode,
                                               Integer rescueCode,
                                               String type,
                                               Integer dealStatus,
                                               Long sequenceNbr,
                                               int current, int size);

    List<ElevatorWlInfoDto>  queryElevatorListDetails(
            Long sequenceNbr
    );

    int  queryElevatorListCount();

    List<ElevatorDto> selectExportData(@Param("ids") List<String> ids);
    @Select("select * from tcb_elevator where address like concat('%',#{address},'%')")
    List<ElevatorDto> getAddressList(String address);
}
