package com.yeejoin.amos.api.common.restful.utils;

import org.springframework.http.HttpStatus;

public class ResponseHelper {

    public static <T> ResponseModel<T> buildResponse(T t) {
        ResponseModel<T> response = new ResponseModel<>();
        response.setResult(t);
        response.setMessage("ok");
        response.setStatus(HttpStatus.OK.value());
        return response;
    }

    /**
     * 失败的响应
     *
     * @param result       接口执行结果
     * @param errorMessage 错误信息
     * @param status       HttpStatus 响应状态码
     * @param <T>
     * @return 响应
     */
    public static <T> ResponseModel<T> buildFailureResponse(T result, String errorMessage, HttpStatus status) {
        ResponseModel<T> response = new ResponseModel<>();
        response.setStatus(status.value());
        response.setMessage(errorMessage);
        response.setResult(result);
        return response;
    }

}
