package com.yeejoin.amos.api.openapi.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

@AllArgsConstructor
@Getter
public enum CylinderInspectionFieldEnum {
    sequenceCode(true, true),
    inspectionUnit(true, false),
    inspectionDate(true, false),
    inspectionResult(true, false),
    scrapQuantity(true, false),
    nextInspectionDate(true, false),
    syncDate(true, false),
    syncState(true, false);

    private final boolean isRequire;
    private final boolean isUnique;

    public static List<String> getAllRequireKeys() {
        return Arrays.stream(values()).filter(e -> e.isRequire).map(Enum::name).collect(Collectors.toList());
    }

    public  static List<String> getAllUniqueKeys() {
        return Arrays.stream(values()).filter(e -> e.isUnique).map(Enum::name).collect(Collectors.toList());
    }

}
