package com.yeejoin.amos.boot.module.elevator.flc.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 气瓶充装检查情况统计表-企业
 *
 * @author system_generator
 * @date 2022-03-11
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tz_cylinder_filling_check_data_unit")
public class CylinderFillingCheckDataUnit extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 充装次数
     */
    @TableField("total_sum")
    private Long totalSum;

    /**
     * 充装次数*2(充装检查合格率组态配置temp字段)
     */
    @TableField("total_sum_double")
    private Long totalSumDouble;

    /**
     * 充装前检查数
     */
    @TableField("filling_count")
    private Long fillingCount;

    /**
     * 充装前检查率
     */
    @TableField("filling_percent")
    private Double fillingPercent;

    /**
     * 充装后检查数
     */
    @TableField("filling_check_count")
    private Long fillingCheckCount;

    /**
     * 充装后检查率
     */
    @TableField("filling_check_percent")
    private Double fillingCheckPercent;

    /**
     * 充装检查合格数
     */
    @TableField("filling_passed_count")
    private Long fillingPassedCount;

    /**
     * 充装检查合格率
     */
    @TableField("filling_passed_percent")
    private Double fillingPassedPercent;
    /**
     * 企业编码
     */
    @TableField("app_id")
    private String appId;

    /**
     * 更新时间
     */
    @TableField("update_time")
    private Date updateTime;

    /**
     * 充装年份
     */
    @TableField("filling_year")
    private String fillingYear;

    /**
     * 充装月份
     */
    @TableField("filling_month")
    private String fillingMonth;
    //filling_date

    /**
     * 充装年月
     */
    @TableField("filling_date")
    private String fillingDate;
}
