package com.yeejoin.amos.boot.module.common.api.enums;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;

public enum JgBusinessTypeEnum {
    SGGZ("sggz","施工告知"),
    SYDJ("sydj","使用登记"),
    BGDJ("bgdj","变更登记"),
    TYQY("tyqy","停用启用"),
    ZXBX("zxbf","注销报废");


    private JgBusinessTypeEnum(String code, String name){
        this.code=code;
        this.name=name;
    }

    private String code;

    private String name;

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static List<HashMap<String,Object>> getEnumList() {
        List<HashMap<String, Object>> list = new ArrayList<>();
        for (JgBusinessTypeEnum testEnum : EnumSet.allOf(JgBusinessTypeEnum.class)) {
            HashMap<String, Object> map = new HashMap<>();
            map.put("title",testEnum.name);
            map.put("value",testEnum.code);
            list.add(map);
        }
        return list;
    }

}
