package com.yeejoin.amos.boot.module.jg.api.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 单位变更登记
 *
 * @author system_generator
 * @date 2023-12-22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "JgChangeRegistrationUnitDto", description = "单位变更登记")
public class JgChangeRegistrationUnitDto extends BaseDto {

    private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "变更类型（0转出，1转入）")
    private String changeType;

    @ApiModelProperty(value = "申请编号")
    private String applyNo;

    @ApiModelProperty(value = "申请日期")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date applyDate;

    @ApiModelProperty(value = "列表搜索接收申请日期时使用")
    private String applicationDate;

    @ApiModelProperty(value = "办理状态")
    private String auditStatus;

    @ApiModelProperty(value = "登记机构")
    private String receiveOrgName;

    @ApiModelProperty(value = "登记机构代码")
    private String receiveOrgCode;

    @ApiModelProperty(value = "登记机构公司代码")
    private String receiveCompanyCode;

    @ApiModelProperty(value = "终审通过时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date auditPassDate;

    @ApiModelProperty(value = "列表搜索接收终审通过时间时使用")
    private String auditPass;

    @ApiModelProperty(value = "备注")
    private String remark;

    @ApiModelProperty(value = "创建人ID")
    private String createUserId;

    @ApiModelProperty(value = "创建时间")
    @JsonFormat(pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonSerialize(using = BizCustomDateSerializer.class)
    private Date createDate;

    @ApiModelProperty(value = "创建人")
    private String createUserName;

    @ApiModelProperty(value = "原使用单位统一信用代码")
    private String useUnitCreditCode;

    @ApiModelProperty(value = "原使用单位名称")
    private String useUnitName;

    @ApiModelProperty(value = "新使用单位统一信用代码")
    private String newUseUnitCreditCode;

    @ApiModelProperty(value = "新使用单位名称")
    private String newUseUnitName;

    @ApiModelProperty(value = "变更证明（买卖合同或其他变更使用单位证明）")
    private String changeCertificate;

    @ApiModelProperty(value = "变更证明（买卖合同或其他变更使用单位证明）")
    private List<Map<String, Object>> changeCertificateList;

    @ApiModelProperty(value = "流程实例id")
    private String instanceId;

    @ApiModelProperty(value = "流程执行顺序标识")
    private String executeSequence;

    @ApiModelProperty(value = "下一执行节点ids")
    private String nextExecutorIds;

    @ApiModelProperty(value = "任务发起人id")
    private String promoter;

    @ApiModelProperty(value = "使用登记证书附件（转入审核通过后生成）")
    private String useRegistrationCertificate;

    @ApiModelProperty(value = "流程已执行记录角色id")
    private String instanceStatus;

    @ApiModelProperty(value = "当前节点流程名称")
    private String status;

    @ApiModelProperty(value = "流程建议")
    private String processAdvice;

    @TableField(exist = false)
    @ApiModelProperty(value = "告知设备列表")
    private List<Map<String, Object>> deviceList;

    @TableField(exist = false)
    @ApiModelProperty(value = "使用登记证列表")
    private List<Map<String, Object>> registrationList;

    @ApiModelProperty(value = "装置列表")
    private List<Map<String, Object>> projectContraptionList;

    @ApiModelProperty(value = "设备类别")
    private String equType;

    private List<String> roleIds;

    @ApiModelProperty(value = "设备名称")
    private String productNameB;

    @ApiModelProperty(value = "设备注册代码")
    private String equCodeB;

    @ApiModelProperty(value = "设备内部编号")
    private String useInnerCode;

    @ApiModelProperty(value = "设备使用登记注册编号")
    private String useRegistCode;

    @ApiModelProperty(value = "设备地址")
    private String equAddress;

    @ApiModelProperty(value = "下一步任务id")
    private String nextTaskId;

    @ApiModelProperty(value = "下一步执行人userids")
    private String nextExecuteUserIds;

    @ApiModelProperty(value = "监管码")
    private String supervisoryCode;

    @ApiModelProperty(value = "设备种类")
    private String equList;

    @ApiModelProperty(value = "设备类别")
    private String equCategory;

    @ApiModelProperty(value = "设备品种")
    private String equDefine;

    @ApiModelProperty(value = "96333识别码")
    private String code96333;

    @ApiModelProperty(value = "转办人")
    private String transferToUserIds;

    @ApiModelProperty(value = "其他附件")
    private List<Map<String, Object>> otherAccessoriesList;

    @ApiModelProperty(value = "其他附件")
    private String otherAccessories;

    @ApiModelProperty(value = "公司类型")
    private String companyType;

    @ApiModelProperty(value = "经办人")
    private String agent;

    @ApiModelProperty(value = "经办人联系电话")
    private String agentPhone;

    @ApiModelProperty(value = "设备种类编码")
    private String equListCode;

    @ApiModelProperty(value = "接收机构公司的org_code")
    private String receiveCompanyOrgCode;
}
