package com.yeejoin.amos.boot.module.jg.biz.edit.decorator;

import com.yeejoin.amos.boot.biz.common.bo.ReginParams;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;

import java.util.Map;


public class CompanyDecorator extends ResultDecorator<Map<String, Object>> {

    private final ReginParams reginParams;

    public CompanyDecorator(ResultProcessor<Map<String, Object>> processor, ReginParams reginParams) {
        super(processor);
        this.reginParams = reginParams;
    }

    @Override
    public Map<String, Object> process(Map<String, Object> stringMap) {
        processor.process(stringMap);
        if (reginParams.getCompany().getLevel().equals(BaseController.COMPANY_TYPE_COMPANY)) {
            stringMap.put("companyType", BaseController.COMPANY_TYPE_COMPANY);
        } else {
            stringMap.put("companyType", BaseController.COMPANY_TYPE_SUPERVISION);
        }
        return stringMap;
    }
}
