package com.yeejoin.amos.boot.module.jg.biz.edit.process.biz.vehicleInformation;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformation;
import com.yeejoin.amos.boot.module.jg.api.entity.JgVehicleInformationEq;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationEqServiceImpl;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.JgVehicleInformationServiceImpl;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Getter
public class VehicleInformationEditUpdateService {

    private final JgVehicleInformationServiceImpl mainService;

    private final JgVehicleInformationEqServiceImpl eqService;

    public Set<String> getEqsByApplyNo(String applyNo) {
        JgVehicleInformation JgVehicleInformation = getOneByApplyNoSingle(applyNo);
        List<JgVehicleInformationEq> eqs = eqService.list(new LambdaQueryWrapper<JgVehicleInformationEq>().eq(JgVehicleInformationEq::getVehicleId, JgVehicleInformation.getSequenceNbr()).select(JgVehicleInformationEq::getEquId, BaseEntity::getSequenceNbr));
        return eqs.stream().map(JgVehicleInformationEq::getEquId).collect(Collectors.toSet());
    }

    public JgVehicleInformation getOneByApplyNo(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgVehicleInformation>().eq(JgVehicleInformation::getApplyNo, applyNo));
    }

    private JgVehicleInformation getOneByApplyNoSingle(String applyNo) {
        return mainService.getOne(new LambdaQueryWrapper<JgVehicleInformation>().eq(JgVehicleInformation::getApplyNo, applyNo).select(BaseEntity::getSequenceNbr));
    }

}