package com.yeejoin.amos.boot.module.jyjc.biz.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.yeejoin.amos.boot.module.common.api.dao.ESEquipmentCategory;
import com.yeejoin.amos.boot.module.common.api.dto.ESEquipmentCategoryDto;
import com.yeejoin.amos.boot.module.common.api.enums.EquipmentClassifityEnum;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplication;
import com.yeejoin.amos.boot.module.jyjc.api.entity.JyjcInspectionApplicationEquip;
import com.yeejoin.amos.boot.module.jyjc.api.model.InspectionPlanModel;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgProjectContraption;
import com.yeejoin.amos.boot.module.ymt.api.mapper.IdxBizJgProjectContraptionMapper;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;

import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * @author Administrator
 */
@Service
public class InspectionPlanServiceImpl {

    private final IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper;

    private final JyjcInspectionApplicationServiceImpl inspectionApplicationService;

    private final JyjcInspectionApplicationEquipServiceImpl applicationEquipService;

    private final JyjcInspectionResultServiceImpl inspectionResultService;

    private final ESEquipmentCategory esEquipmentCategory;

    public InspectionPlanServiceImpl(JyjcInspectionApplicationServiceImpl inspectionApplicationService,
                                     JyjcInspectionApplicationEquipServiceImpl applicationEquipService,
                                     JyjcInspectionResultServiceImpl inspectionResultService, ESEquipmentCategory esEquipmentCategory, IdxBizJgProjectContraptionMapper idxBizJgProjectContraptionMapper) {
        this.inspectionApplicationService = inspectionApplicationService;
        this.applicationEquipService = applicationEquipService;
        this.inspectionResultService = inspectionResultService;
        this.esEquipmentCategory = esEquipmentCategory;
        this.idxBizJgProjectContraptionMapper = idxBizJgProjectContraptionMapper;
    }


    public InspectionPlanModel savePlanData(String applicationSeq, InspectionPlanModel model) {
        LambdaUpdateWrapper<JyjcInspectionApplication> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.set(JyjcInspectionApplication::getPlanData, JSONObject.toJSONString(model));
        updateWrapper.eq(BaseEntity::getSequenceNbr, applicationSeq);
        updateWrapper.set(JyjcInspectionApplication::getPlanCreateDate, new Date());
        updateWrapper.set(JyjcInspectionApplication::getPlanInspectionDate, model.getPlanInspectionDate());
        inspectionApplicationService.update(updateWrapper);
        // 异步写入计划排期日期，统计办理时效使用
        this.updatePlanCreateDate(applicationSeq);
        return model;
    }

    private void updatePlanCreateDate(String applicationSeq) {
        JyjcInspectionApplication inspectionApplication = inspectionApplicationService.getById(applicationSeq);
        inspectionResultService.updatePlanCreateDateByAppNo(inspectionApplication.getApplicationNo());
    }

    public JSONObject getDetail(String applicationSeq) {
        JyjcInspectionApplication inspectionApplication = inspectionApplicationService.getById(applicationSeq);
        // 初始时查询设备地址关联设备表
        JSONObject jsonObject = inspectionApplication.getPlanData();
        if (jsonObject == null) {
            jsonObject = new JSONObject();
            String address = this.getOneEquipAddress(inspectionApplication);
            jsonObject.put("address", address);
        }
        return jsonObject;
    }

    private String getOneEquipAddress(JyjcInspectionApplication application) {
        // 压力管道取装置使用/安装地址
        if (EquipmentClassifityEnum.YLGD.getCode().equals(application.getEquipClassify())) {
            IdxBizJgProjectContraption projectContraption = idxBizJgProjectContraptionMapper.selectById(application.getProjectContraptionId());
            return Stream.of(projectContraption.getProvinceName(), projectContraption.getCityName(), projectContraption.getCountyName(), projectContraption.getStreetName(), projectContraption.getAddress())
                    .map(value -> value == null ? "" : value)
                    .collect(Collectors.joining());
        } else {
            // 其他取第一个设备使用/安装地址
            List<JyjcInspectionApplicationEquip> applicationEquips = applicationEquipService.list(new LambdaQueryWrapper<JyjcInspectionApplicationEquip>().eq(JyjcInspectionApplicationEquip::getApplicationSeq, application.getSequenceNbr()));
            if (!applicationEquips.isEmpty()) {
                Optional<ESEquipmentCategoryDto> optional = esEquipmentCategory.findById(applicationEquips.get(0).getEquipUnicode());
                if (optional.isPresent()) {
                    ESEquipmentCategoryDto esEquipmentCategoryDto = optional.get();
                    return this.concatDetailAddress(esEquipmentCategoryDto);
                }
            }
            return "";
        }
    }

    private String concatDetailAddress(ESEquipmentCategoryDto esEquipmentCategoryDto) {
        return Stream.of(esEquipmentCategoryDto.getUSE_PLACE(), esEquipmentCategoryDto.getADDRESS()).map(a -> a == null ? "" : a.replace("/", "").trim()).collect(Collectors.joining());
    }
}
