package com.yeejoin.amos.patrol.dao.entity;

import com.fasterxml.jackson.annotation.JsonBackReference;

import javax.persistence.*;
import java.util.List;


/**
 * The persistent class for the p_route_point database table.
 * 
 */
@Entity
@Table(name="p_route_point")
@NamedQuery(name="RoutePoint.findAll", query="SELECT r FROM RoutePoint r")
public class RoutePoint extends BasicEntity {
	private static final long serialVersionUID = 1L;

	/**
     * 创建者
     */
	@Column(name="creator_id")
	private String creatorId;
	/**
	 * 权限org code
	 */
	@Column(name="org_code")
	private String orgCode;
	
	/**
	 * 点id
	 */
	@Column(name="point_id")
	private long pointId;
	
	/**
	 * 路线id
	 */
	@Column(name="route_id")
	private long routeId;
	
	/**
	 * 排序
	 */
	@Column(name="order_no")
	private int orderNo;

	/**
	 * 排除项
	 */
	@Column(name="exclude_items")
	private String excludeItems;

	/**
	 * 前端标记删除
	 */
	private boolean isDelete=false;

	private Route route;
	
	private List<RoutePointItem> routePointItem;


	public RoutePoint() {
	}

	public String getCreatorId() {
		return this.creatorId;
	}

	public void setCreatorId(String creatorId) {
		this.creatorId = creatorId;
	}

	public String getOrgCode() {
		return this.orgCode;
	}

	public void setOrgCode(String orgCode) {
		this.orgCode = orgCode;
	}

	public long getPointId() {
		return this.pointId;
	}

	public void setPointId(long pointId) {
		this.pointId = pointId;
	}

	public long getRouteId() {
		return this.routeId;
	}

	public void setRouteId(long routeId) {
		this.routeId = routeId;
	}

	@ManyToOne
	@JoinColumn(name = "routeId", referencedColumnName = "id", updatable = false, insertable = false)	
	public Route getRoute() {
		return route;
	}
	@JsonBackReference
	public void setRoute(Route route) {
		this.route = route;
	}

	@OneToMany(mappedBy = "routePoint", cascade = {CascadeType.REMOVE} )
	public List<RoutePointItem> getRoutePointItem() {
		return routePointItem;
	}

	public void setRoutePointItem(List<RoutePointItem> routePointItem) {
		this.routePointItem = routePointItem;
	}
	
	public int getOrderNo() {
		return orderNo;
	}

	public void setOrderNo(int orderNo) {
		this.orderNo = orderNo;
	}

	@Transient
	public boolean getIsDelete() {
		return isDelete;
	}

	public void setIsDelete(boolean isDelete) {
		this.isDelete = isDelete;
	}

	public String getExcludeItems() {
		return excludeItems;
	}

	public void setExcludeItems(String excludeItems) {
		this.excludeItems = excludeItems;
	}

}
