package com.yeejoin.amos.patrol.business.service.intfc;

import com.yeejoin.amos.patrol.business.param.InputItemPageParam;
import com.yeejoin.amos.patrol.business.util.DaoCriteria;
import com.yeejoin.amos.patrol.business.vo.InputItemVo;
import com.yeejoin.amos.patrol.business.vo.PointInputItemVo;
import com.yeejoin.amos.patrol.dao.entity.InputItem;
import org.springframework.data.domain.Page;

import java.util.HashMap;
import java.util.List;

/**
 * 	检查项业务处理实体
 * @author gaodongdong
 *
 */
public interface IInputItemService {


	/**
	 * 新接口
	 *
	 * */


	/**
	 * 	分页列表条件查询检查项
	 * @param criterias
	 * @return
	 */
	public Page<InputItemVo> queryInputItemByPageNew(InputItemPageParam criterias);




	/**
	 * 新接口
	 *
	 * */










	/**
	 * 	新增检查项
	 * @param inputItem 检查项
	 * @return
	 */
	public long addNewInputItem(InputItem inputItem);

	/**
	 *   	查询检查项详情
	 * @param id
	 * @return
	 */
	public InputItem queryInputItemDetail(Long id);

	/**
	 * 	修改检查项
	 *
	 * @param inputItem 检查项
	 */
	public void updateInputItem(InputItem inputItem);

	/**
	 * 	 删除检查项
	 *
	 * @param id
	 */
	public void delInputItem(Long id);


	/**
	 * 	分页条件查询检查项
	 * @param criterias
	 * @return
	 */
	public Page<InputItemVo> queryInputItemByPage(InputItemPageParam criterias);

	/**
	 * 	条件查询检查项
	 * @param criterias
	 * @return
	 */
	public List<InputItem> queryInputItemByCondition(List<DaoCriteria> criterias);

	/**
	 * 	条件查询检查项个数
	 * @param params
	 * @return
	 */
	public int queryInputItemCountByCondition(List<DaoCriteria> criterias);

	/**
	 * 另存为
	 * @param ids
	 * @param long1
	 */
	public void saveAs(String[] ids, String userId);

	/**
	 *	 批量删除检查项
	 * @param ids
	 */
	public void batchDelInputItem(String[] ids);

	/**
	 * 获取组织下所有巡检项
	 * @param loginOrgCode
	 * @return
	 */
	public String[] queryInputItemNames(String loginOrgCode);


	public List<String> qryItemNoList(List<DaoCriteria> criterias, Long itemId);
	/**
	 * 获取组织下所有巡检项
	 * @param dictCode
	 * @return
	 */
	public Object getCheckClassify(String token, String product, String appKey, String dictCode);

	List<PointInputItemVo>  queryCustomInputItem (String itemType, String nameOrItemNo, String orgCode);

	List<PointInputItemVo>  queryCustomInputItemNew (HashMap<String,Object> param, String orgCode, String companyBizOrgCode);
}
