package com.yeejoin.amos.boot.module.jg.api.dto;

import com.alibaba.fastjson.JSON;
import com.yeejoin.amos.boot.biz.common.annotation.FieldDisplayDefine;
import com.yeejoin.amos.boot.biz.common.annotation.Group;
import lombok.Data;
import lombok.EqualsAndHashCode;

@EqualsAndHashCode(callSuper = true)
@Data
@Group(value = "equip_register_info")
public class EquipRegisterChangeDataDto extends BaseChangeDataDto {

    @FieldDisplayDefine(value = "设备种类" ,isExist = false)
    private String equList;

    @FieldDisplayDefine(value = "设备类别")
    private String equCategory;

    @FieldDisplayDefine(value = "设备代码")
    private String equCode;
    /**
     * 1-手工输入、2-系统自动生成
     */
    @FieldDisplayDefine(value = "设备代码类型" ,isExist = false)
    private String equCodeType;

    @FieldDisplayDefine(value = "设备品种")
    private String equDefine;

    @FieldDisplayDefine(value = "产品名称")
    private String productName;

    @FieldDisplayDefine(value = "设备型号")
    private String equType;

    @FieldDisplayDefine(value = "设备总价值（万元）")
    private String equPrice;

    @FieldDisplayDefine(value = "产品照片（可上传产品铭牌）", type = JSON.class)
    private String productPhoto;

    @FieldDisplayDefine(value = "其他附件", type = JSON.class)
    private String otherAccessoriesReg;
}
