package com.yeejoin.amos.boot.module.jg.biz.service.impl;

import com.yeejoin.amos.boot.module.jg.api.dto.ESDataChangeLogDto;
import com.yeejoin.amos.boot.module.jg.api.dto.JgBizChangeLogDto;
import com.yeejoin.amos.boot.module.jg.api.entity.JgBizChangeLog;
import com.yeejoin.amos.boot.module.jg.api.mapper.JgBizChangeLogMapper;
import com.yeejoin.amos.boot.module.jg.api.service.IJgBizChangeLogService;
import com.yeejoin.amos.boot.module.jg.biz.dao.ESDataChangeLogDao;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import java.util.List;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2025-04-14
 */
@Service
@RequiredArgsConstructor
public class JgBizChangeLogServiceImpl extends BaseService<JgBizChangeLogDto, JgBizChangeLog, JgBizChangeLogMapper> implements IJgBizChangeLogService {


    private final ESDataChangeLogDao esDataChangeLogDao;

    public void save2DbAndEs(JgBizChangeLog changeLog, List<ESDataChangeLogDto> esDataChangeLogDtos) {
        this.save(changeLog);
        esDataChangeLogDtos.forEach(esDataChangeLogDto -> {
            esDataChangeLogDto.setBatchId(changeLog.getSequenceNbr() + "");
        });
        if (!esDataChangeLogDtos.isEmpty()) {
            esDataChangeLogDao.saveAll(esDataChangeLogDtos);
        }
    }
}