package com.yeejoin.amos.boot.module.statistics.api.mapper;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.dto.CountDto;
import com.yeejoin.amos.boot.module.common.api.dto.DPFilterParamDto;
import com.yeejoin.amos.boot.module.ymt.api.entity.IdxBizJgOtherInfo;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 大屏Mapper 接口
 *
 * @author maxy
 * @date 2024-07-09
 */
@Mapper
public interface ZLStatisticsMapper {

    List<Map<String, Object>> getCompanyInfo(@Param("screenDto") DPFilterParamDto screenDto);

    List<Map<String, Object>> testOrg(@Param("screenDto") DPFilterParamDto screenDto);

    List<Map<String, String>> userCount(@Param("screenDto") DPFilterParamDto screenDto);

    List<Map<String, Object>> supervisorCount(@Param("screenDto") DPFilterParamDto screenDto);

    String getOrgCodeByCompanyCode(@Param("cityCode") String cityCode);

    List<Map<String, String>> userCountNew(@Param("screenDto") DPFilterParamDto screenDto, @Param("unitTypeList") List<String> unitTypeList);

    Long countCompanyForCertDateTimeOut(@Param("dto") DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode, @Param("limitDate") String limitDate);

    Long countCompanyForCertDateTemporary(@Param("dto")DPFilterParamDto dpFilterParamDto, @Param("orgCode") String orgCode, @Param("limitDate") String limitDate);

    Long getEquipTotal(@Param("cityCode") String cityCode);

    Long getEquListTotal(@Param("field") String field, @Param("cityCode") String cityCode);

    Page<Map<String, Object>> getPersonPage(Page page, @Param("paramDto") DPFilterParamDto paramDto, @Param("orgCode") String orgCode, @Param("unitTypeList") List<String> unitTypeList);

    Integer count();

    IPage<IdxBizJgOtherInfo> getEquipInfoPage(IPage<IdxBizJgOtherInfo> idxBizJgOtherInfoPage);

    List<CountDto> countUserByPostAndAreaCode(@Param("orgCode") String orgCode, @Param("regionCode") String regionCode, Boolean isOrgCodeExactMatch);

}
