package com.yeejoin.amos.boot.module.jg.biz.utils;

import java.util.Map;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @Author: xl
 * @Description:
 * @Date: 2022/8/4 9:08
 */
public class StringUtils {
    
    private final static String regex = "^(?:[1-9]\\d*(?:\\.\\d*)?|0(?:\\.\\d+)?)(?:/(?:[1-9]\\d*(?:\\.\\d*)?|0(?:\\.\\d+)?))*$";

    public static StringJoiner getWhereSql(String operator, Map<String, String> map){
        StringJoiner stringJoiner = new StringJoiner(" " + operator +" ");
        for (Map.Entry entry :map.entrySet()) {
            stringJoiner.add(entry.getKey() + "=" + str2sqlValue(entry.getValue().toString()));
        }
        return stringJoiner;
    }

    public static String str2sqlValue(String str){
        return "'" + str + "'";
    }

    public static String getStrByPattern(String str, Pattern reg){
        Matcher mat = reg.matcher(str);
        while (mat.find()) {
            return mat.group(0);
        }
        return "";
    }
    
    public static Boolean isValidMultiSlash(String str){
        if (str == null) {
            return false;
        }
        return Pattern.compile(regex).matcher(str).matches();
    }
}
