package com.yeejoin.amos.boot.module.tcm.api.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.common.api.dto.UserPermissionDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.GroupAndPersonInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsEquipListDto;
import com.yeejoin.amos.boot.module.tcm.api.dto.TzsUserInfoDto;
import com.yeejoin.amos.boot.module.tcm.api.entity.TzsUserInfo;
import com.yeejoin.amos.boot.module.tcm.api.vo.SortVo;
import com.yeejoin.amos.boot.module.tcm.api.vo.UserInfoVo;
import com.yeejoin.amos.feign.privilege.model.CompanyModel;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

public interface TzsUserInfoMapper extends BaseMapper<TzsUserInfo> {
    Page<TzsUserInfoDto> selectPageMessage(@Param("page") Page<TzsUserInfoDto> page,
                                           @Param("dto") TzsUserInfoDto dto,
                                           @Param("sort") SortVo sortMap);

    List<UserInfoVo> queryUserInfoInIds(@Param("ids") List<String> ids);

    List<Map<String, Object>> getUserType(@Param("unitType")String unitType, @Param("install") String install);

    Map<String, Integer> getArrangementStatistic(String companyCode);

    Page<TzsEquipListDto> getAllEquipList(@Param("page") Page<TzsEquipListDto> page,
                                          @Param("type") String type,
                                          @Param("companyCode") String companyCode,
                                          @Param("userSeq") String userSeq,
                                          @Param("dto") TzsEquipListDto dto);

    List<TzsUserInfo> getUnitPersonInfo();

    List<String> selectUserIds();

    List<GroupAndPersonInfoDto> getUnitInfoByUserId(Long groupId);

    String selectPostNameByUserId(String userId);

    List<Map<String, Object>> getUserTypeList(@Param(value = "typeList") List<String> typeList);

    String selectCompanyTypeById(Long companySeq);

    CompanyModel selectPrivilegeCompanyByCompanyCode(@Param("companyCode") String companyCode);

    /**
     * 已资质为维度查询人
     * @param page 分页对象
     * @param post 岗位数组
     * @param filter 筛选条件
     * @return 分页对象列表
     */
    Page<UserPermissionDto> queryUserByPermissionPage(Page<UserPermissionDto> page,
                                                      @Param("postList") List<String> post,
                                                      @Param("filter") UserPermissionDto filter,
                                                      @Param("sort") SortVo sortMap);

    /**
     *  查询指定单位下的人
     * @param filter 单位过滤条件
     * @return 对象列表
     */
    List<UserPermissionDto> queryUserByPermissionOfOneCompany(@Param("filter") UserPermissionDto filter);

    List<TzsUserInfoDto> select6616User();

    /**
     * 用户绑定设备数量
     *
     * @param userSeq 用户userId
     * @return 数量
     */
    @Select("SELECT count(1) from tzs_user_equip where user_seq = #{userSeq}")
    Integer queryUserBindEquNum(@Param("userSeq") String userSeq);
}
