package com.yeejoin.amos.boot.module.jg.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.yeejoin.amos.boot.biz.common.entity.BaseEntity;
import com.yeejoin.amos.boot.module.jg.api.common.BizCustomDateSerializer;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.util.Date;

/**
 * 改造变更登记
 *
 * @author system_generator
 * @date 2023-12-20
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("tzs_jg_change_registration_reform")
public class JgChangeRegistrationReform extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 设备监管码
     */
	@TableField("supervisory_code")
    private String supervisoryCode;

    /**
     * 使用单位名称
     */
	@TableField("use_unit_name")
    private String useUnitName;

    /**
     * 申请编号
     */
	@TableField("apply_no")
    private String applyNo;

    /**
     * 办理状态
     */
	@TableField("audit_status")
    private String auditStatus;

    /**
     * 登记机构
     */
	@TableField("receive_org_name")
    private String receiveOrgName;

    /**
     * 检验单位
     */
	@TableField("inspect_unit_name")
    private String inspectUnitName;

    /**
     * 检验结果照片
     */
	@TableField("inspect_result_photo")
    private String inspectResultPhoto;

    /**
     * 检验结果
     */
	@TableField("inspect_result")
    private String inspectResult;

    /**
     * 终审通过时间
     */
	@TableField("audit_pass_date")
    private Date auditPassDate;

    /**
     * 登记类别
     */
	@TableField("reg_type")
    private String regType;

    /**
     * 注册登记日期
     */
	@TableField("reg_date")
    private Date regDate;

    /**
     * 注册登记人员ID
     */
	@TableField("reg_person_id")
    private String regPersonId;

    /**
     * 注册登记人员
     */
	@TableField("reg_person_name")
    private String regPersonName;

    /**
     * 安装单位名称
     */
	@TableField("install_unit_name")
    private String installUnitName;

    /**
     * 状态
     */
	@TableField("status")
    private String status;

    /**
     * 备注
     */
	@TableField("remark")
    private String remark;

    /**
     * 创建人ID
     */
	@TableField("create_user_id")
    private String createUserId;

    /**
     * 创建时间
     */
	@TableField("create_date")
    private Date createDate;

    /**
     * 录入单位统一信用代码
     */
	@TableField("input_unit_no")
    private String inputUnitNo;

    /**
     * 使用登记编号
     */
	@TableField("use_registration_code")
    private String useRegistrationCode;

    /**
     * 流程实例id
     */
	@TableField("instance_id")
    private String instanceId;

    /**
     * 使用单位统一信用代码
     */
	@TableField("use_unit_credit_code")
    private String useUnitCreditCode;

    /**
     * 检验机构统一信用代码
     */
	@TableField("inspect_unit_credit_code")
    private String inspectUnitCreditCode;

    /**
     * 流程执行顺序标识
     */
	@TableField("execute_sequence")
    private String executeSequence;

    /**
     * 登记机构代码
     */
	@TableField("receive_org_code")
    private String receiveOrgCode;

    /**
     * 登记机构公司代码
     */
	@TableField("receive_company_code")
    private String receiveCompanyCode;


    /**
     * 改造告知申请id
     */
	@TableField("reform_notice_id")
    private String reformNoticeId;


    @TableField("instance_status")
    private String instanceStatus;

    /**
     * 下一执行节点ids
     */
    @TableField("next_executor_ids")
    private String nextExecutorIds;

    /**
     * 任务发起人id
     */
    @TableField(value = "promoter")
    private String promoter;

    /**
     * 改造质量证明材料
     */
    @TableField(value = "transformation_quality_certificate")
    private String transformationQualityCertificate;


    /**
     *改造监督检验证书
     */
    @TableField(value = "renovation_supervisioninspection_certificate")
    private String renovationSupervisioninspectionCertificate;


    /**
     *工作流下一节点任务id
     */
    @TableField(value = "next_task_id")
    private String nextTaskId;
    /**
     * 创建人
     */
    @TableField("create_user_name")
    private String createUserName;
    /**
     *
     */
    @TableField(value = "create_user_company_name")
    private String createUserCompanyName;
    /**
     *
     */
    @TableField(value = "equip_list_name")
    private String equipListName;
    /*
     * 下一节点可执行人
     */
    @TableField("next_execute_user_ids")
    private String nextExecuteUserIds;
    /*
     * 历史转办人
     */
    @TableField(value = "transfer_to_user_ids")
    private String transferToUserIds;


    /**
     * 其他附件
     */
    @TableField(value = "other_accessories")
    private String otherAccessories;

    /**
     * 接收机构公司的org_code
     */
    @TableField("receive_company_org_code")
    private String receiveCompanyOrgCode;

    /**
     * 作废原因
     */
    @TableField("cancel_reason")
    private String cancelReason;

    /**
     * 作废日期
     */
    @TableField("cancel_date")
    private Date cancelDate;

    /**
     * 作废人员id
     */
    @TableField("cancel_user_id")
    private String cancelUserId;

    /**
     * 作废人员名称（冗余字段）
     */
    @TableField("cancel_user_name")
    private String cancelUserName;
}
