package com.yeejoin.amos.boot.module.jg.biz.controller;


import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.module.jg.biz.service.impl.DataHandlerServiceImpl;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import javax.annotation.Resource;

/**
 * 用于业务变更过程中历史数据处理的控制层
 */
@Api(tags = "用于业务变更过程中历史数据处理的控制层")
@RestController
@RequestMapping(value = "/dataHandler")
public class DataHandlerController extends BaseController {

    @Resource
    private DataHandlerServiceImpl dataHandlerService;


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "安装告知压力管道历史数据修复-详情中的设备列表修改为汇总表格式", notes = "安装告知压力管道历史数据修复-详情中的设备列表修改为汇总表格式")
    @GetMapping(value = "/installNotice/deviceListInForm")
    public ResponseModel<Boolean> deviceListInFormWithInstallNotice() {
        return ResponseHelper.buildResponse(dataHandlerService.deviceListInFormWithInstallNotice());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "向新增的工程装置表刷入数据", notes = "向新增的工程装置表刷入数据")
    @GetMapping(value = "/projectContraption/writeData")
    public ResponseModel<Boolean> writeData2ProjectContraption() {
        return ResponseHelper.buildResponse(dataHandlerService.writeData2ProjectContraption());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "刷入工程装置id到es的idx_biz_view_jg_all索引", notes = "刷入工程装置id到es的idx_biz_view_jg_all索引")
    @GetMapping(value = "/jgAllIndex/writeProjectContraptionId")
    public ResponseModel<String> writeProjectContraptionId() {
        return ResponseHelper.buildResponse(dataHandlerService.writeProjectContraptionId());
    }

    /**
     * 向新增的工程装置表刷入数据(补充使用单位code为空的)
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(httpMethod = "GET", value = "向新增的工程装置表刷入数据,条件是未做使用登记，使用单位code为空的", notes = "向新增的工程装置表刷入数据,条件是未做使用登记，使用单位code为空的")
    @GetMapping(value = "/projectContraption/writeDataUseCodeIsNull")
    public ResponseModel<Boolean> writeDataUseCodeIsNull2ProjectContraption() {
        return ResponseHelper.buildResponse(dataHandlerService.writeDataUseCodeIsNull2ProjectContraption());
    }


    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @ApiOperation(value = "使用登记表属地监管部门历史数据处理",notes = "supervisionOrgCode在history表json数据写入，气瓶导入页面无此字段，使用单位的属地监管部门写入")
    @PutMapping(value = "/useRegistration/supervisionOrgCode")
    public ResponseModel<Boolean> writeSupervisionOrgCode2UseRegister(){
        dataHandlerService.writeSupervisionOrgCode2UseRegister();
        return ResponseHelper.buildResponse(true);
    }

}
