package com.yeejoin.amos.boot.biz.common.utils;

import com.itextpdf.text.*;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;

import javax.servlet.http.HttpServletResponse;

/**
 * PDF工具类
 */
public class PdfUtils {

    private  static  int maxWidth = 520;

    public static Document  createFile(HttpServletResponse response) {        // 设置页面大小,联系文件
        Document  document=new Document();
        document.setPageSize(PageSize.A4);
        document.setPageCount(3);
        try {
            PdfWriter.getInstance(document, response.getOutputStream());
            document.open();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return document;
    }

    /**
     *
     * @param value 单元格数据
     * @param font  单元格样式
     * @param align 位置
     * @param colspan 占几列
     * @param row 占几行
     * @param size 高度
     * @return
     */
    public static PdfPCell createCell(String value, Font font, int align, int colspan, int row, int size){
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setPhrase(new Phrase(value,font));
        cell.setFixedHeight(size);
        if (row != 1) {
            cell.setRowspan(row);
        }
        return cell;
    }
    public static PdfPCell createCell(Image image, int align, int colspan){
        PdfPCell cell = new PdfPCell();
        cell.setVerticalAlignment(Element.ALIGN_MIDDLE);
        cell.setHorizontalAlignment(align);
        cell.setColspan(colspan);
        cell.setImage(image);
        cell.setPadding(3.0f);
        cell.setBorderWidthLeft(0);
        cell.setBorderWidthRight(0);
        cell.setBorderWidthTop(0);
        cell.setBorderWidthBottom(1);
        return cell;
    }

    // 创建一个几列的Table
    public static PdfPTable createTable(int colNumber){
        PdfPTable table = new PdfPTable(colNumber);
        try{
            table.setTotalWidth(maxWidth);
            table.setLockedWidth(true);
            table.setHorizontalAlignment(Element.ALIGN_CENTER);
        }catch(Exception e){
            e.printStackTrace();
        }
        return table;
    }
}
