package com.yeejoin.amos.boot.module.common.biz.service.impl;

import java.util.List;
import java.util.Optional;

import javax.annotation.Resource;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.typroject.tyboot.core.rdbms.annotation.Condition;
import org.typroject.tyboot.core.rdbms.annotation.Operator;
import org.typroject.tyboot.core.rdbms.service.BaseService;

import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.utils.EnumsUtils;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceCraneDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceHydrantDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceIotDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourceNaturalDto;
import com.yeejoin.amos.boot.module.common.api.dto.WaterResourcePoolDto;
import com.yeejoin.amos.boot.module.common.api.entity.WaterResource;
import com.yeejoin.amos.boot.module.common.api.enums.WaterResourceTypeEnum;
import com.yeejoin.amos.boot.module.common.api.mapper.WaterResourceMapper;
import com.yeejoin.amos.boot.module.common.api.service.IWaterResourceService;

/**
 * 服务实现类
 *
 * @author system_generator
 * @date 2021-06-29
 */
@Service
public class WaterResourceServiceImpl extends BaseService<WaterResourceDto, WaterResource, WaterResourceMapper> implements IWaterResourceService {

    @Autowired
    WaterResourceCraneServiceImpl waterResourceCraneService;
    @Autowired
    WaterResourceHydrantServiceImpl waterResourceHydrantService;
    @Autowired
    WaterResourceNaturalServiceImpl waterResourceNaturalService;
    @Autowired
    WaterResourcePoolServiceImpl waterResourcePoolService;
    @Autowired
    WaterResourceIotServiceImpl waterResourceIotService;
    @Resource
    WaterResourceMapper waterResourceMapper;

    /**
     * 分页查询
     */
    public Page<WaterResourceDto> queryForWaterResourcePage(Page<WaterResourceDto> page,
                                                            @Condition(Operator.like) String name,
                                                            @Condition(Operator.eq) String resourceType,
                                                            @Condition(Operator.eq) Boolean isDelete) {
        return this.queryForPage(page, null, false, name, resourceType, isDelete);
    }

    /**
     * 列表查询 示例
     */
    public List<WaterResourceDto> queryForWaterResourceList(@Condition(Operator.eq) Boolean isDelete) {
        return this.queryForList("", false, isDelete);
    }


    /**
     * excel导入
     *
     * @param model
     * @return
     */
    public WaterResourceDto importByExcel(WaterResourceDto model) {
        String resourceType = model.getResourceType();
        Optional<WaterResourceTypeEnum> resourceTypeEnum = EnumsUtils.getEnumObject(WaterResourceTypeEnum.class,
                e -> e.getCode().equals(resourceType));
        model.setResourceTypeName(resourceTypeEnum.get().getName());
        model.setRealityImg(JSONArray.toJSONString(model.getRealityImgList()));
        model.setOrientationImg(JSONArray.toJSONString(model.getOrientationImgList()));
        if (!StringUtils.isEmpty(resourceType)) {
            switch (resourceType) {
                case "hydrant":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    // 新增属性信息
                    WaterResourceHydrantDto waterResourceHydrantDto = new WaterResourceHydrantDto();
                    BeanUtils.copyProperties(model, waterResourceHydrantDto);
                    waterResourceHydrantDto.setSequenceNbr(null);
                    waterResourceHydrantDto.setResourceId(model.getSequenceNbr());
                    waterResourceHydrantService.createWithModel(waterResourceHydrantDto);
                    break;
                case "crane":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    WaterResourceCraneDto waterResourceCraneDto = new WaterResourceCraneDto();
                    BeanUtils.copyProperties(model, waterResourceCraneDto);
                    waterResourceCraneDto.setSequenceNbr(null);
                    waterResourceCraneDto.setResourceId(model.getSequenceNbr());
                    waterResourceCraneService.createWithModel(waterResourceCraneDto);
                    break;
                case "natural":
                    // 新增基础信息
                    model.setIsIot(false);
                    createWithModel(model);
                    WaterResourceNaturalDto waterResourceNaturalDto = new WaterResourceNaturalDto();
                    BeanUtils.copyProperties(model, waterResourceNaturalDto);
                    waterResourceNaturalDto.setSequenceNbr(null);
                    waterResourceNaturalDto.setResourceId(model.getSequenceNbr());
                    waterResourceNaturalService.createWithModel(waterResourceNaturalDto);
                    break;
                case "pool":
                    // 新增基础信息
                    model.setIsIot(true);
                    createWithModel(model);
                    WaterResourcePoolDto waterResourcePoolDto = new WaterResourcePoolDto();
                    BeanUtils.copyProperties(model, waterResourcePoolDto);
                    waterResourcePoolDto.setSequenceNbr(null);
                    waterResourcePoolDto.setResourceId(model.getSequenceNbr());
                    waterResourcePoolService.createWithModel(waterResourcePoolDto);
                    break;
            }
            // 新增物联信息
            if (model.getIsIot()) {
                WaterResourceIotDto waterResourceIotDto = new WaterResourceIotDto();
                BeanUtils.copyProperties(model, waterResourceIotDto);
                waterResourceIotDto.setSequenceNbr(null);
                waterResourceIotDto.setResourceType(model.getResourceType());
                waterResourceIotDto.setResourceId(model.getSequenceNbr());
                waterResourceIotService.createWithModel(waterResourceIotDto);
            }
        } else {
            createWithModel(model);
        }
        return model;
    }

    /**
     * 导出列表
     */
    public List<WaterResourceDto> exportToExcel(@Condition(Operator.eq) Boolean isDelete) {
        return waterResourceMapper.exportToExcel(isDelete);
    }
}
