package com.yeejoin.amos.boot.module.jcs.biz.controller;

import java.util.Arrays;

import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferSimpleDto;
import com.yeejoin.amos.boot.module.jcs.api.feign.EquipFeignClient;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.*;
import org.typroject.tyboot.core.foundation.enumeration.UserType;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import com.yeejoin.amos.boot.biz.common.utils.NameUtils;
import com.yeejoin.amos.boot.module.jcs.api.dto.PowerTransferDto;
import com.yeejoin.amos.boot.module.jcs.api.entity.PowerTransfer;
import com.yeejoin.amos.boot.module.jcs.biz.service.impl.PowerTransferServiceImpl;
import com.yeejoin.amos.feign.privilege.model.AgencyUserModel;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 力量调派
 *
 * @author tb
 * @date 2021-06-17
 */
@RestController
@Api(tags = "力量调派Api")
@RequestMapping(value = "/power-transfer")
public class PowerTransferController extends BaseController {

    @Autowired
    PowerTransferServiceImpl powerTransferService;

    @Autowired
    EquipFeignClient equipFeignClient;

    /**
     * 新增力量调派
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "新增力量调派", notes = "新增力量调派")
    public boolean savePowerTransfer(@RequestBody PowerTransfer powerTransfer) {
        return powerTransferService.save(powerTransfer);
    }

    /**
     * 根据id删除
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.DELETE)
    @ApiOperation(httpMethod = "DELETE", value = "根据id删除", notes = "根据id删除")
    public boolean deleteById(@PathVariable Long id) {
        return powerTransferService.removeById(id);
    }


    /**
     * 修改力量调派
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/updateById", method = RequestMethod.PUT)
    @ApiOperation(httpMethod = "PUT", value = "修改力量调派", notes = "修改力量调派")
    public boolean updateByIdPowerTransfer(@RequestBody PowerTransfer powerTransfer) {
        return powerTransferService.updateById(powerTransfer);
    }


    /**
     * 根据id查询
     *
     * @param id id
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/{id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据id查询", notes = "根据id查询")
    public PowerTransfer selectById(@PathVariable Long id) {
        return powerTransferService.getById(id);
    }

    /**
     * 列表分页查询
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "列表分页查询", notes = "列表分页查询")
    public IPage<PowerTransfer> listPage(String pageNum, String pageSize, PowerTransfer powerTransfer) {

        Page<PowerTransfer> pageBean;
        QueryWrapper<PowerTransfer> powerTransferQueryWrapper = new QueryWrapper<>();
        Class<? extends PowerTransfer> aClass = powerTransfer.getClass();
        Arrays.stream(aClass.getDeclaredFields()).forEach(field -> {
            try {
                field.setAccessible(true);
                Object o = field.get(powerTransfer);
                if (o != null) {
                    Class<?> type = field.getType();
                    String name = NameUtils.camel2Underline(field.getName());
                    if (type.equals(Integer.class)) {
                        Integer fileValue = (Integer) field.get(powerTransfer);
                        powerTransferQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(Long.class)) {
                        Long fileValue = (Long) field.get(powerTransfer);
                        powerTransferQueryWrapper.eq(name, fileValue);
                    } else if (type.equals(String.class)) {
                        String fileValue = (String) field.get(powerTransfer);
                        powerTransferQueryWrapper.eq(name, fileValue);
                    } else {
                        String fileValue = (String) field.get(powerTransfer);
                        powerTransferQueryWrapper.eq(name, fileValue);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
        IPage<PowerTransfer> page;
        if (StringUtils.isBlank(pageNum) || StringUtils.isBlank(pageSize)) {
            pageBean = new Page<>(0, Long.MAX_VALUE);
        } else {
            pageBean = new Page<>(Integer.parseInt(pageNum), Integer.parseInt(pageSize));
        }
        page = powerTransferService.page(pageBean, powerTransferQueryWrapper);
        return page;
    }

    /**
     * 根据警情id获取力量调派列表
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/list/{alert_called_id}", method = RequestMethod.GET)
    @ApiOperation(httpMethod = "GET", value = "根据警情id获取力量调派列表", notes = "根据警情id获取力量调派列表")
    public ResponseModel<PowerTransferSimpleDto> list(@PathVariable String alert_called_id) {
        PowerTransferSimpleDto powerTransferSimpleDto =
                powerTransferService.getPowerTransferList(Long.parseLong(alert_called_id));
        return ResponseHelper.buildResponse(powerTransferSimpleDto);
    }

    /**
     * 力量调派-任务派发
     *
     * @return 返回结果
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @RequestMapping(value = "/create", method = RequestMethod.POST)
    @ApiOperation(httpMethod = "POST", value = "力量调派-任务派发", notes = "力量调派-任务派发")
    public ResponseModel<Boolean> createPowerTransfer(@RequestBody PowerTransferDto powerTransferDto) {
        AgencyUserModel userInfo = getUserInfo();
        powerTransferDto.setTaskSenderId(Long.parseLong(userInfo.getUserId()));
        powerTransferDto.setTaskSenderName(userInfo.getUserName());

        String companyName = getSelectedOrgInfo().getCompany().getCompanyName();
        powerTransferDto.setCompanyName(companyName);

        boolean save = powerTransferService.createPowerTransfer(powerTransferDto);
        return ResponseHelper.buildResponse(save);
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/power/tree")
    @ApiOperation(value = "力量调派资源树", notes = "力量调派资源树")
    public ResponseModel<Object> getPowerTree() {
        return ResponseHelper.buildResponse(powerTransferService.getPowerTree());
    }

    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @GetMapping(value = "/power/list")
    @ApiOperation(value = "力量出动列表", notes = "力量调派资源树")
    public ResponseModel<Object> getPowerTransferList(@ApiParam(value = "开始日期", required = true) @RequestParam String beginDate,
                                                      @ApiParam(value = "结束日期", required = true) @RequestParam String endDate) {
        return ResponseHelper.buildResponse(powerTransferService.getPowerTransferList(beginDate, endDate));
    }


}

