package com.yeejoin.amos.boot.module.cylinder.flc.biz.controller;

import org.springframework.web.bind.annotation.RequestMapping;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Api;
import org.springframework.web.bind.annotation.RestController;
import com.yeejoin.amos.boot.biz.common.controller.BaseController;
import java.util.List;
import com.yeejoin.amos.boot.module.cylinder.flc.biz.service.impl.CylinderTagsDataUnitServiceImpl;
import org.typroject.tyboot.core.restful.utils.ResponseHelper;
import org.typroject.tyboot.core.restful.utils.ResponseModel;
import org.springframework.beans.factory.annotation.Autowired;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.yeejoin.amos.boot.module.cylinder.flc.api.dto.CylinderTagsDataUnitDto;
import org.typroject.tyboot.core.restful.doc.TycloudOperation;
import org.typroject.tyboot.core.foundation.enumeration.UserType;

/**
 * 气瓶及标签数量比表-企业
 *
 * @author system_generator
 * @date 2022-03-11
 */
@RestController
@Api(tags = "气瓶及标签数量比表-企业Api")
@RequestMapping(value = "/cylinder-tags-data-unit")
public class CylinderTagsDataUnitController extends BaseController {

    @Autowired
    CylinderTagsDataUnitServiceImpl cylinderTagsDataUnitServiceImpl;

    /**
     * 新增气瓶及标签数量比表-企业
     *
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
	@PostMapping(value = "/save")
	@ApiOperation(httpMethod = "POST", value = "新增气瓶及标签数量比表-企业", notes = "新增气瓶及标签数量比表-企业")
	public ResponseModel<CylinderTagsDataUnitDto> save(@RequestBody CylinderTagsDataUnitDto model) {
	    model = cylinderTagsDataUnitServiceImpl.createWithModel(model);
	    return ResponseHelper.buildResponse(model);
	}

	/**
     * 根据sequenceNbr更新
     *
     * @param sequenceNbr 主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@PutMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "PUT", value = "根据sequenceNbr更新气瓶及标签数量比表-企业", notes = "根据sequenceNbr更新气瓶及标签数量比表-企业")
	public ResponseModel<CylinderTagsDataUnitDto> updateBySequenceNbrCylinderTagsDataUnit(@RequestBody CylinderTagsDataUnitDto model,@PathVariable(value = "sequenceNbr") Long sequenceNbr) {
	    model.setSequenceNbr(sequenceNbr);
	    return ResponseHelper.buildResponse(cylinderTagsDataUnitServiceImpl.updateWithModel(model));
	}

	/**
     * 根据sequenceNbr删除
     *
     * @param sequenceNbr 主键
     * @return
     */
    @TycloudOperation(ApiLevel = UserType.AGENCY)
    @DeleteMapping(value = "/{sequenceNbr}")
    @ApiOperation(httpMethod = "DELETE", value = "根据sequenceNbr删除气瓶及标签数量比表-企业", notes = "根据sequenceNbr删除气瓶及标签数量比表-企业")
    public ResponseModel<Boolean> deleteBySequenceNbr(HttpServletRequest request, @PathVariable(value = "sequenceNbr") Long sequenceNbr){
        return ResponseHelper.buildResponse(cylinderTagsDataUnitServiceImpl.removeById(sequenceNbr));
    }

    /**
     * 根据sequenceNbr查询
     *
	 * @param sequenceNbr  主键
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/{sequenceNbr}")
	@ApiOperation(httpMethod = "GET",value = "根据sequenceNbr查询单个气瓶及标签数量比表-企业",  notes = "根据sequenceNbr查询单个气瓶及标签数量比表-企业")
	public ResponseModel<CylinderTagsDataUnitDto> selectOne(@PathVariable Long sequenceNbr) {
	    return ResponseHelper.buildResponse(cylinderTagsDataUnitServiceImpl.queryBySeq(sequenceNbr));
	}

	/**
     * 列表分页查询
     *
     * @param current 当前页
     * @param current 每页大小
     * @return
     */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@GetMapping(value = "/page")
	@ApiOperation(httpMethod = "GET",value = "气瓶及标签数量比表-企业分页查询",  notes = "气瓶及标签数量比表-企业分页查询")
	public ResponseModel<Page<CylinderTagsDataUnitDto>> queryForPage(@RequestParam(value = "current") int current,@RequestParam
                    (value = "size") int size) {
	    Page<CylinderTagsDataUnitDto> page = new Page<CylinderTagsDataUnitDto>();
	    page.setCurrent(current);
	    page.setSize(size);
	    return ResponseHelper.buildResponse(cylinderTagsDataUnitServiceImpl.queryForCylinderTagsDataUnitPage(page));
	}

	/**
	 * 列表全部数据查询
     *
	 * @return
	 */
	@TycloudOperation(ApiLevel = UserType.AGENCY)
	@ApiOperation(httpMethod = "GET",value = "气瓶及标签数量比表-企业列表全部数据查询",   notes = "气瓶及标签数量比表-企业列表全部数据查询")
	@GetMapping(value = "/list")
	public ResponseModel<List<CylinderTagsDataUnitDto>> selectForList() {
	    return ResponseHelper.buildResponse(cylinderTagsDataUnitServiceImpl.queryForCylinderTagsDataUnitList());
	}
}
