package com.yeejoin.amos.boot.module.jg.api.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class VehicleCylinderConverter implements Converter<String> {

    private static final String WHETHER = "是";
    private static final String NOT = "否";


    @Override
    public Class<?> supportJavaTypeKey() {
        // 实体类中对象属性类型
        return String.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        // Excel中对应的CellData属性类型
        return CellDataTypeEnum.STRING;
    }

    @Override
    public String convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty,
                                     GlobalConfiguration globalConfiguration) {
        // 从Cell中读取数据
        String cellValue = cellData.getStringValue();
        // 判断Excel中的值，将其转换为预期的数值
        if (WHETHER.equals(cellValue)) {
            return "0";
        } else if (NOT.equals(cellValue)) {
            return "1";
        }
        return null;
    }

    @Override
    public CellData convertToExcelData(String o, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 判断实体类中获取的值，转换为Excel预期的值，并封装为CellData对象
        if (o == null) {
            return new CellData("");
        } else if (o.equals("0")) {
            return new CellData(WHETHER);
        } else if (o.equals("1")) {
            return new CellData(NOT);
        }
        return new CellData("");
    }
}