package com.yeejoin.amos.boot.module.common.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;
/**
* 微型消防站
*
* @author system_generator
* @date 2021-06-28
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="FireStationDto", description="微型消防站")
public class FireStationDto  extends BaseDto {

   private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "微型消防站名称")
    private String name;

    @ApiModelProperty(value = "所在建筑物id")
    private String whereBuildingId;

    @ApiModelProperty(value = "所在建筑物名称")
    private String whereBuilding;

    @ApiModelProperty(value = "装备简要情况")
    private String equipmentBrief;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经度")
    private Double longitude;

    @ApiModelProperty(value = "纬度")
    private Double latitude;

    @ApiModelProperty(value = "行政区区划名称")
    private String administrativeDivisions;

    @ApiModelProperty(value = "行政区区划编号")
    private String administrativeDivisionsCode;

    @ApiModelProperty(value = "值班室电话")
    private String dutyRoomTelephone;

    @ApiModelProperty(value = "负责人名称")
    private String personChargeName;

    @ApiModelProperty(value = "负责人电话")
    private String personChargeTelephone;

    @ApiModelProperty(value = "单位id")
    private Long bizCompanyId;

    @ApiModelProperty(value = "所属单位名称")
    private String bizCompany;

    @ApiModelProperty(value = "所属单位code")
    private String bizCompanyCode;

    @ApiModelProperty(value = "建造日期")
    private Date buildTime;

    @ApiModelProperty(value = "启用日期")
    private Date enableTime;

    @ApiModelProperty(value = "图片信息")
    private String img;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "操作人名称")
    private String recUserName;
    
    @ApiModelProperty(value = "战备装备数量")
    private Integer eqNum;
    
    @ApiModelProperty(value = "战备人数量")
    private Integer userNum;
    
    @ApiModelProperty(value = "战备车辆数量")
    private Integer carNum;

}
