package com.yeejoin.amos.boot.module.common.api.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
* 
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="WaterResourceDto", description="")
public class WaterResourceDto  extends BaseDto {

   private static final long serialVersionUID = 1L;



    @ApiModelProperty(value = "资源名称")
    private String name;

    @ApiModelProperty(value = "地址")
    private String address;

    @ApiModelProperty(value = "经纬度坐标")
    private String latLang;

    @ApiModelProperty(value = "资源类型（消火栓、消防水鹤、天然水源、消防水池）")
    private String type;

    @ApiModelProperty(value = "所在建筑id")
    private Long belongBuildingId;

    @ApiModelProperty(value = "所在建筑")
    private String belongBuilding;

    @ApiModelProperty(value = "所属消防系统id")
    private Long belongFightingSystemId;

    @ApiModelProperty(value = "所属消防系统")
    private String belongFightingSystem;

    @ApiModelProperty(value = "管理单位id")
    private Long managementUnitId;

    @ApiModelProperty(value = "管理单位")
    private String managementUnit;

    @ApiModelProperty(value = "维保单位id")
    private Long maintenanceUnitId;

    @ApiModelProperty(value = "维保单位")
    private String maintenanceUnit;

    @ApiModelProperty(value = "建造日期")
    private Date buildDate;

    @ApiModelProperty(value = "启用日期")
    private Date enableDate;

    @ApiModelProperty(value = "方位图")
    private String orientationImg;

    @ApiModelProperty(value = "实景图")
    private String realityImg;

    @ApiModelProperty(value = "联系人姓名")
    private String contactUser;

    @ApiModelProperty(value = "联系人电话")
    private String contactPhone;

    @ApiModelProperty(value = "是否有物联参数（1有，0没有）")
    private Boolean isIot;

    @ApiModelProperty(value = "消防救援机构_通用唯一识别码")
    private String rescueOrgCode;

    @ApiModelProperty(value = "行政区划代码")
    private String administrativeCode;

    @ApiModelProperty(value = "更新人员")
    private String recUserName;

    @ApiModelProperty(value = "组织机构代码")
    private String orgCode;

}
