package com.yeejoin.amos.boot.module.common.api.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.typroject.tyboot.core.rdbms.orm.entity.BaseEntity;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
/**
* 
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@TableName("cb_water_resource_crane")
public class WaterResourceCrane extends BaseEntity {

    private static final long serialVersionUID = 1L;


    /**
	  * 资源id
     */
	@TableField("resource_id")
    private Long resourceId;
    /**
	  * 高度（cm）
     */
	@TableField("height")
    private Float height;
    /**
	  * 水源可用状态类别代码
     */
	@TableField("status_code")
    private String statusCode;
    /**
	  * 水源可用状态类别名称
     */
	@TableField("status")
    private String status;
    /**
	  * 所属路段
     */
	@TableField("section")
    private String section;
    /**
	  * 所属管网
     */
	@TableField("pipe_network")
    private String pipeNetwork;
    /**
	  * 消防给水管网形式类型代码
     */
	@TableField("pipe_type_code")
    private String pipeTypeCode;
    /**
	  * 消防给水管网形式类型名称
     */
	@TableField("pipe_type_name")
    private String pipeTypeName;
    /**
	  * 官网直径（cm）
     */
	@TableField("pipe_diameter")
    private Float pipeDiameter;
    /**
	  * 进水管直径(cm)
     */
	@TableField("inlet_pipe_diameter")
    private Float inletPipeDiameter;
    /**
	  * 出水管直径(cm)
     */
	@TableField("outlet_pipe_diameter")
    private Float outletPipeDiameter;
    /**
	  * 加水车道数量(个)
     */
	@TableField("waterfilling_lane_num")
    private Integer waterfillingLaneNum;
    /**
	  * 供水单位名称
     */
	@TableField("water_supply_name")
    private String waterSupplyName;
    /**
	  * 更新人员
     */
	@TableField("rec_user_name")
    private String recUserName;
}
