package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.yeejoin.amos.boot.biz.common.dto.BaseDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
/**
* 航空器信息
*
* @author system_generator
* @date 2021-06-29
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AircraftDto", description="航空器信息")
public class AircraftDto  extends BaseDto {

   private static final long serialVersionUID = 1L;


    @ApiModelProperty(value = "飞机型号")
    private String aircraftModel;

    @ApiModelProperty(value = "中文全称")
    private String fullName;

    @ApiModelProperty(value = "飞机长度")
    private Double aircraftLength;

    @ApiModelProperty(value = "机舱长度")
    private Double cabinLength;

    @ApiModelProperty(value = "尾翼高度")
    private Double tailHeight;

    @ApiModelProperty(value = "翼展")
    private Double wingspan;

    @ApiModelProperty(value = "机身直径")
    private Double fuselageDiameter;

    @ApiModelProperty(value = "翼展面积")
    private Double wingspanArea;

    @ApiModelProperty(value = "发动机类型")
    private String engineType;

    @ApiModelProperty(value = "发动机类型code")
    private String engineTypeCode;

    @ApiModelProperty(value = "发动机数量")
    private Integer enginesmNum;

    @ApiModelProperty(value = "发动机型号")
    private String engineModel;

    @ApiModelProperty(value = "燃油类型")
    private String fuelType;

    @ApiModelProperty(value = "燃油类型code")
    private String fuelTypeCode;

    @ApiModelProperty(value = "最大载油量")
    private Double oilLoadMax;

    @ApiModelProperty(value = "标准燃油")
    private Double standardFuel;

    @ApiModelProperty(value = "空重")
    private Double emptyWeight;

    @ApiModelProperty(value = "飞机主要构造材料")
    private String structuralMaterial;

    @ApiModelProperty(value = "氧气瓶数量")
    private Integer oxygenCylinderNum;

    @ApiModelProperty(value = "氧气瓶位置描述")
    private String oxygenCylinderLocation;

    @ApiModelProperty(value = "标准坐席数")
    private Integer seatNum;

    @ApiModelProperty(value = "商载(吨)")
    private Double commercialLoad;

    @ApiModelProperty(value = "货仓容积（立方米）")
    private Double warehouseVolume;

    @ApiModelProperty(value = "最大起飞总重（吨）")
    private Double takeoffWeightNum;

    @ApiModelProperty(value = "最大巡航速度（马赫）")
    private Double cruiseSpeedNum;

    @ApiModelProperty(value = "航程")
    private Double voyage;

    @ApiModelProperty(value = "主要设施")
    private String facilitie;

    @ApiModelProperty(value = "主要燃烧物质")
    private String combustionMaterial;

    @ApiModelProperty(value = "疏散出口及安全通道")
    private String exitPassage;

    @ApiModelProperty(value = "备注")
    private String remark;
    
    @ApiModelProperty(value = "外观图")
    private String appearanceImages;
    
    @ApiModelProperty(value = "平面图")
    private String planeImages;
    
    @ApiModelProperty(value = "救援图")
    private String rescueImages;
    
    @ApiModelProperty(value = "方位图")
    private String positionImages;
    
    @ApiModelProperty(value = "三维模型")
    private String models;

}
