package com.yeejoin.amos.boot.module.jcs.api.dto;

import com.alibaba.fastjson.JSONObject;
import com.yeejoin.amos.boot.biz.common.dto.BaseDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
* 警情报送记录
*
* @author tb
* @date 2021-06-17
*/
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value="AlertSubmittedDto", description="警情报送记录")
public class AlertSubmittedDto extends BaseDto{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键id")
    private Long sequenceNbr;

    @ApiModelProperty(value = "警情id")
    private Long alertCalledId;

    @ApiModelProperty(value = "业务类型code(警情续报、非警情确认、警情结案)")
    private String businessTypeCode;

    @ApiModelProperty(value = "通话记录id")
    private String callLogId;

    @ApiModelProperty(value = "调度类型code(融合调度、外部协调)")
    private String schedulingTypeCode;

    /**
     * 区分是警情报送还是融合调度
     * 电话：融合调度
     * 短信：警情报送
     */
    @ApiModelProperty(value = "报送方式code(电话、短信)")
    private String submissionMethodCode;

    /**
     * 报送对象
     */
    @ApiModelProperty(value = "报送对象")
    private List<SubmitTargetCompanyDto> submitCompanyList;

    /**
     * 报送内容
     */
    @ApiModelProperty(value = "报送内容")
    private JSONObject submitContent;

    /**
     * 发送对象类型（0：人员，1：单位）
     */
    @ApiModelProperty(value = "报送对象类型0：人员，1：单位")
    private String type;
}
